/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.xray.XRayAsyncClient;
import software.amazon.awssdk.services.xray.model.GetInsightSummariesRequest;
import software.amazon.awssdk.services.xray.model.GetInsightSummariesResponse;

public class GetInsightSummariesPublisher
implements SdkPublisher<GetInsightSummariesResponse> {
    private final XRayAsyncClient client;
    private final GetInsightSummariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetInsightSummariesPublisher(XRayAsyncClient client, GetInsightSummariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetInsightSummariesPublisher(XRayAsyncClient client, GetInsightSummariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetInsightSummariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetInsightSummariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetInsightSummariesResponseFetcher
    implements AsyncPageFetcher<GetInsightSummariesResponse> {
        private GetInsightSummariesResponseFetcher() {
        }

        public boolean hasNextPage(GetInsightSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetInsightSummariesResponse> nextPage(GetInsightSummariesResponse previousPage) {
            if (previousPage == null) {
                return GetInsightSummariesPublisher.this.client.getInsightSummaries(GetInsightSummariesPublisher.this.firstRequest);
            }
            return GetInsightSummariesPublisher.this.client.getInsightSummaries((GetInsightSummariesRequest)((Object)GetInsightSummariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

