/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.TelemetryRecord;
import software.amazon.awssdk.services.xray.model.TelemetryRecordListCopier;
import software.amazon.awssdk.services.xray.model.XRayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutTelemetryRecordsRequest
extends XRayRequest
implements ToCopyableBuilder<Builder, PutTelemetryRecordsRequest> {
    private static final SdkField<List<TelemetryRecord>> TELEMETRY_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TelemetryRecords").getter(PutTelemetryRecordsRequest.getter(PutTelemetryRecordsRequest::telemetryRecords)).setter(PutTelemetryRecordsRequest.setter(Builder::telemetryRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TelemetryRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TelemetryRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EC2_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EC2InstanceId").getter(PutTelemetryRecordsRequest.getter(PutTelemetryRecordsRequest::ec2InstanceId)).setter(PutTelemetryRecordsRequest.setter(Builder::ec2InstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2InstanceId").build()}).build();
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Hostname").getter(PutTelemetryRecordsRequest.getter(PutTelemetryRecordsRequest::hostname)).setter(PutTelemetryRecordsRequest.setter(Builder::hostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hostname").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceARN").getter(PutTelemetryRecordsRequest.getter(PutTelemetryRecordsRequest::resourceARN)).setter(PutTelemetryRecordsRequest.setter(Builder::resourceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TELEMETRY_RECORDS_FIELD, EC2_INSTANCE_ID_FIELD, HOSTNAME_FIELD, RESOURCE_ARN_FIELD));
    private final List<TelemetryRecord> telemetryRecords;
    private final String ec2InstanceId;
    private final String hostname;
    private final String resourceARN;

    private PutTelemetryRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.telemetryRecords = builder.telemetryRecords;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.hostname = builder.hostname;
        this.resourceARN = builder.resourceARN;
    }

    public final boolean hasTelemetryRecords() {
        return this.telemetryRecords != null && !(this.telemetryRecords instanceof SdkAutoConstructList);
    }

    public final List<TelemetryRecord> telemetryRecords() {
        return this.telemetryRecords;
    }

    public final String ec2InstanceId() {
        return this.ec2InstanceId;
    }

    public final String hostname() {
        return this.hostname;
    }

    public final String resourceARN() {
        return this.resourceARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTelemetryRecords() ? this.telemetryRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceARN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTelemetryRecordsRequest)) {
            return false;
        }
        PutTelemetryRecordsRequest other = (PutTelemetryRecordsRequest)((Object)obj);
        return this.hasTelemetryRecords() == other.hasTelemetryRecords() && Objects.equals(this.telemetryRecords(), other.telemetryRecords()) && Objects.equals(this.ec2InstanceId(), other.ec2InstanceId()) && Objects.equals(this.hostname(), other.hostname()) && Objects.equals(this.resourceARN(), other.resourceARN());
    }

    public final String toString() {
        return ToString.builder((String)"PutTelemetryRecordsRequest").add("TelemetryRecords", this.hasTelemetryRecords() ? this.telemetryRecords() : null).add("EC2InstanceId", (Object)this.ec2InstanceId()).add("Hostname", (Object)this.hostname()).add("ResourceARN", (Object)this.resourceARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TelemetryRecords": {
                return Optional.ofNullable(clazz.cast(this.telemetryRecords()));
            }
            case "EC2InstanceId": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceId()));
            }
            case "Hostname": {
                return Optional.ofNullable(clazz.cast(this.hostname()));
            }
            case "ResourceARN": {
                return Optional.ofNullable(clazz.cast(this.resourceARN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutTelemetryRecordsRequest, T> g) {
        return obj -> g.apply((PutTelemetryRecordsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends XRayRequest.BuilderImpl
    implements Builder {
        private List<TelemetryRecord> telemetryRecords = DefaultSdkAutoConstructList.getInstance();
        private String ec2InstanceId;
        private String hostname;
        private String resourceARN;

        private BuilderImpl() {
        }

        private BuilderImpl(PutTelemetryRecordsRequest model) {
            super(model);
            this.telemetryRecords(model.telemetryRecords);
            this.ec2InstanceId(model.ec2InstanceId);
            this.hostname(model.hostname);
            this.resourceARN(model.resourceARN);
        }

        public final List<TelemetryRecord.Builder> getTelemetryRecords() {
            List<TelemetryRecord.Builder> result = TelemetryRecordListCopier.copyToBuilder(this.telemetryRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder telemetryRecords(Collection<TelemetryRecord> telemetryRecords) {
            this.telemetryRecords = TelemetryRecordListCopier.copy(telemetryRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryRecords(TelemetryRecord ... telemetryRecords) {
            this.telemetryRecords(Arrays.asList(telemetryRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryRecords(Consumer<TelemetryRecord.Builder> ... telemetryRecords) {
            this.telemetryRecords(Stream.of(telemetryRecords).map(c -> (TelemetryRecord)((TelemetryRecord.Builder)TelemetryRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTelemetryRecords(Collection<TelemetryRecord.BuilderImpl> telemetryRecords) {
            this.telemetryRecords = TelemetryRecordListCopier.copyFromBuilder(telemetryRecords);
        }

        public final String getEc2InstanceId() {
            return this.ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        public final String getHostname() {
            return this.hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final String getResourceARN() {
            return this.resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutTelemetryRecordsRequest build() {
            return new PutTelemetryRecordsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends XRayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutTelemetryRecordsRequest> {
        public Builder telemetryRecords(Collection<TelemetryRecord> var1);

        public Builder telemetryRecords(TelemetryRecord ... var1);

        public Builder telemetryRecords(Consumer<TelemetryRecord.Builder> ... var1);

        public Builder ec2InstanceId(String var1);

        public Builder hostname(String var1);

        public Builder resourceARN(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

