/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.Compute;
import software.amazon.awssdk.services.workspaces.model.RunningMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkspaceProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkspaceProperties> {
    private static final SdkField<String> RUNNING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RunningMode").getter(WorkspaceProperties.getter(WorkspaceProperties::runningModeAsString)).setter(WorkspaceProperties.setter(Builder::runningMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunningMode").build()}).build();
    private static final SdkField<Integer> RUNNING_MODE_AUTO_STOP_TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RunningModeAutoStopTimeoutInMinutes").getter(WorkspaceProperties.getter(WorkspaceProperties::runningModeAutoStopTimeoutInMinutes)).setter(WorkspaceProperties.setter(Builder::runningModeAutoStopTimeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunningModeAutoStopTimeoutInMinutes").build()}).build();
    private static final SdkField<Integer> ROOT_VOLUME_SIZE_GIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RootVolumeSizeGib").getter(WorkspaceProperties.getter(WorkspaceProperties::rootVolumeSizeGib)).setter(WorkspaceProperties.setter(Builder::rootVolumeSizeGib)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootVolumeSizeGib").build()}).build();
    private static final SdkField<Integer> USER_VOLUME_SIZE_GIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UserVolumeSizeGib").getter(WorkspaceProperties.getter(WorkspaceProperties::userVolumeSizeGib)).setter(WorkspaceProperties.setter(Builder::userVolumeSizeGib)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserVolumeSizeGib").build()}).build();
    private static final SdkField<String> COMPUTE_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputeTypeName").getter(WorkspaceProperties.getter(WorkspaceProperties::computeTypeNameAsString)).setter(WorkspaceProperties.setter(Builder::computeTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeTypeName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNNING_MODE_FIELD, RUNNING_MODE_AUTO_STOP_TIMEOUT_IN_MINUTES_FIELD, ROOT_VOLUME_SIZE_GIB_FIELD, USER_VOLUME_SIZE_GIB_FIELD, COMPUTE_TYPE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String runningMode;
    private final Integer runningModeAutoStopTimeoutInMinutes;
    private final Integer rootVolumeSizeGib;
    private final Integer userVolumeSizeGib;
    private final String computeTypeName;

    private WorkspaceProperties(BuilderImpl builder) {
        this.runningMode = builder.runningMode;
        this.runningModeAutoStopTimeoutInMinutes = builder.runningModeAutoStopTimeoutInMinutes;
        this.rootVolumeSizeGib = builder.rootVolumeSizeGib;
        this.userVolumeSizeGib = builder.userVolumeSizeGib;
        this.computeTypeName = builder.computeTypeName;
    }

    public final RunningMode runningMode() {
        return RunningMode.fromValue(this.runningMode);
    }

    public final String runningModeAsString() {
        return this.runningMode;
    }

    public final Integer runningModeAutoStopTimeoutInMinutes() {
        return this.runningModeAutoStopTimeoutInMinutes;
    }

    public final Integer rootVolumeSizeGib() {
        return this.rootVolumeSizeGib;
    }

    public final Integer userVolumeSizeGib() {
        return this.userVolumeSizeGib;
    }

    public final Compute computeTypeName() {
        return Compute.fromValue(this.computeTypeName);
    }

    public final String computeTypeNameAsString() {
        return this.computeTypeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.runningModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.runningModeAutoStopTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootVolumeSizeGib());
        hashCode = 31 * hashCode + Objects.hashCode(this.userVolumeSizeGib());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeTypeNameAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceProperties)) {
            return false;
        }
        WorkspaceProperties other = (WorkspaceProperties)obj;
        return Objects.equals(this.runningModeAsString(), other.runningModeAsString()) && Objects.equals(this.runningModeAutoStopTimeoutInMinutes(), other.runningModeAutoStopTimeoutInMinutes()) && Objects.equals(this.rootVolumeSizeGib(), other.rootVolumeSizeGib()) && Objects.equals(this.userVolumeSizeGib(), other.userVolumeSizeGib()) && Objects.equals(this.computeTypeNameAsString(), other.computeTypeNameAsString());
    }

    public final String toString() {
        return ToString.builder((String)"WorkspaceProperties").add("RunningMode", (Object)this.runningModeAsString()).add("RunningModeAutoStopTimeoutInMinutes", (Object)this.runningModeAutoStopTimeoutInMinutes()).add("RootVolumeSizeGib", (Object)this.rootVolumeSizeGib()).add("UserVolumeSizeGib", (Object)this.userVolumeSizeGib()).add("ComputeTypeName", (Object)this.computeTypeNameAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RunningMode": {
                return Optional.ofNullable(clazz.cast(this.runningModeAsString()));
            }
            case "RunningModeAutoStopTimeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.runningModeAutoStopTimeoutInMinutes()));
            }
            case "RootVolumeSizeGib": {
                return Optional.ofNullable(clazz.cast(this.rootVolumeSizeGib()));
            }
            case "UserVolumeSizeGib": {
                return Optional.ofNullable(clazz.cast(this.userVolumeSizeGib()));
            }
            case "ComputeTypeName": {
                return Optional.ofNullable(clazz.cast(this.computeTypeNameAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceProperties, T> g) {
        return obj -> g.apply((WorkspaceProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String runningMode;
        private Integer runningModeAutoStopTimeoutInMinutes;
        private Integer rootVolumeSizeGib;
        private Integer userVolumeSizeGib;
        private String computeTypeName;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceProperties model) {
            this.runningMode(model.runningMode);
            this.runningModeAutoStopTimeoutInMinutes(model.runningModeAutoStopTimeoutInMinutes);
            this.rootVolumeSizeGib(model.rootVolumeSizeGib);
            this.userVolumeSizeGib(model.userVolumeSizeGib);
            this.computeTypeName(model.computeTypeName);
        }

        public final String getRunningMode() {
            return this.runningMode;
        }

        @Override
        public final Builder runningMode(String runningMode) {
            this.runningMode = runningMode;
            return this;
        }

        @Override
        public final Builder runningMode(RunningMode runningMode) {
            this.runningMode(runningMode == null ? null : runningMode.toString());
            return this;
        }

        public final void setRunningMode(String runningMode) {
            this.runningMode = runningMode;
        }

        public final Integer getRunningModeAutoStopTimeoutInMinutes() {
            return this.runningModeAutoStopTimeoutInMinutes;
        }

        @Override
        public final Builder runningModeAutoStopTimeoutInMinutes(Integer runningModeAutoStopTimeoutInMinutes) {
            this.runningModeAutoStopTimeoutInMinutes = runningModeAutoStopTimeoutInMinutes;
            return this;
        }

        public final void setRunningModeAutoStopTimeoutInMinutes(Integer runningModeAutoStopTimeoutInMinutes) {
            this.runningModeAutoStopTimeoutInMinutes = runningModeAutoStopTimeoutInMinutes;
        }

        public final Integer getRootVolumeSizeGib() {
            return this.rootVolumeSizeGib;
        }

        @Override
        public final Builder rootVolumeSizeGib(Integer rootVolumeSizeGib) {
            this.rootVolumeSizeGib = rootVolumeSizeGib;
            return this;
        }

        public final void setRootVolumeSizeGib(Integer rootVolumeSizeGib) {
            this.rootVolumeSizeGib = rootVolumeSizeGib;
        }

        public final Integer getUserVolumeSizeGib() {
            return this.userVolumeSizeGib;
        }

        @Override
        public final Builder userVolumeSizeGib(Integer userVolumeSizeGib) {
            this.userVolumeSizeGib = userVolumeSizeGib;
            return this;
        }

        public final void setUserVolumeSizeGib(Integer userVolumeSizeGib) {
            this.userVolumeSizeGib = userVolumeSizeGib;
        }

        public final String getComputeTypeName() {
            return this.computeTypeName;
        }

        @Override
        public final Builder computeTypeName(String computeTypeName) {
            this.computeTypeName = computeTypeName;
            return this;
        }

        @Override
        public final Builder computeTypeName(Compute computeTypeName) {
            this.computeTypeName(computeTypeName == null ? null : computeTypeName.toString());
            return this;
        }

        public final void setComputeTypeName(String computeTypeName) {
            this.computeTypeName = computeTypeName;
        }

        public WorkspaceProperties build() {
            return new WorkspaceProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkspaceProperties> {
        public Builder runningMode(String var1);

        public Builder runningMode(RunningMode var1);

        public Builder runningModeAutoStopTimeoutInMinutes(Integer var1);

        public Builder rootVolumeSizeGib(Integer var1);

        public Builder userVolumeSizeGib(Integer var1);

        public Builder computeTypeName(String var1);

        public Builder computeTypeName(Compute var1);
    }
}

