/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.Application;
import software.amazon.awssdk.services.workspaces.model.ApplicationListCopier;
import software.amazon.awssdk.services.workspaces.model.Tag;
import software.amazon.awssdk.services.workspaces.model.TagListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.services.workspaces.model.WorkspaceImageIngestionProcess;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportWorkspaceImageRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, ImportWorkspaceImageRequest> {
    private static final SdkField<String> EC2_IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ec2ImageId").getter(ImportWorkspaceImageRequest.getter(ImportWorkspaceImageRequest::ec2ImageId)).setter(ImportWorkspaceImageRequest.setter(Builder::ec2ImageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2ImageId").build()}).build();
    private static final SdkField<String> INGESTION_PROCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngestionProcess").getter(ImportWorkspaceImageRequest.getter(ImportWorkspaceImageRequest::ingestionProcessAsString)).setter(ImportWorkspaceImageRequest.setter(Builder::ingestionProcess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionProcess").build()}).build();
    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageName").getter(ImportWorkspaceImageRequest.getter(ImportWorkspaceImageRequest::imageName)).setter(ImportWorkspaceImageRequest.setter(Builder::imageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()}).build();
    private static final SdkField<String> IMAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageDescription").getter(ImportWorkspaceImageRequest.getter(ImportWorkspaceImageRequest::imageDescription)).setter(ImportWorkspaceImageRequest.setter(Builder::imageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageDescription").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ImportWorkspaceImageRequest.getter(ImportWorkspaceImageRequest::tags)).setter(ImportWorkspaceImageRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Applications").getter(ImportWorkspaceImageRequest.getter(ImportWorkspaceImageRequest::applicationsAsStrings)).setter(ImportWorkspaceImageRequest.setter(Builder::applicationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Applications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_IMAGE_ID_FIELD, INGESTION_PROCESS_FIELD, IMAGE_NAME_FIELD, IMAGE_DESCRIPTION_FIELD, TAGS_FIELD, APPLICATIONS_FIELD));
    private final String ec2ImageId;
    private final String ingestionProcess;
    private final String imageName;
    private final String imageDescription;
    private final List<Tag> tags;
    private final List<String> applications;

    private ImportWorkspaceImageRequest(BuilderImpl builder) {
        super(builder);
        this.ec2ImageId = builder.ec2ImageId;
        this.ingestionProcess = builder.ingestionProcess;
        this.imageName = builder.imageName;
        this.imageDescription = builder.imageDescription;
        this.tags = builder.tags;
        this.applications = builder.applications;
    }

    public final String ec2ImageId() {
        return this.ec2ImageId;
    }

    public final WorkspaceImageIngestionProcess ingestionProcess() {
        return WorkspaceImageIngestionProcess.fromValue(this.ingestionProcess);
    }

    public final String ingestionProcessAsString() {
        return this.ingestionProcess;
    }

    public final String imageName() {
        return this.imageName;
    }

    public final String imageDescription() {
        return this.imageDescription;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final List<Application> applications() {
        return ApplicationListCopier.copyStringToEnum(this.applications);
    }

    public final boolean hasApplications() {
        return this.applications != null && !(this.applications instanceof SdkAutoConstructList);
    }

    public final List<String> applicationsAsStrings() {
        return this.applications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2ImageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionProcessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplications() ? this.applicationsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportWorkspaceImageRequest)) {
            return false;
        }
        ImportWorkspaceImageRequest other = (ImportWorkspaceImageRequest)((Object)obj);
        return Objects.equals(this.ec2ImageId(), other.ec2ImageId()) && Objects.equals(this.ingestionProcessAsString(), other.ingestionProcessAsString()) && Objects.equals(this.imageName(), other.imageName()) && Objects.equals(this.imageDescription(), other.imageDescription()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasApplications() == other.hasApplications() && Objects.equals(this.applicationsAsStrings(), other.applicationsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ImportWorkspaceImageRequest").add("Ec2ImageId", (Object)this.ec2ImageId()).add("IngestionProcess", (Object)this.ingestionProcessAsString()).add("ImageName", (Object)this.imageName()).add("ImageDescription", (Object)this.imageDescription()).add("Tags", this.hasTags() ? this.tags() : null).add("Applications", this.hasApplications() ? this.applicationsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ec2ImageId": {
                return Optional.ofNullable(clazz.cast(this.ec2ImageId()));
            }
            case "IngestionProcess": {
                return Optional.ofNullable(clazz.cast(this.ingestionProcessAsString()));
            }
            case "ImageName": {
                return Optional.ofNullable(clazz.cast(this.imageName()));
            }
            case "ImageDescription": {
                return Optional.ofNullable(clazz.cast(this.imageDescription()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Applications": {
                return Optional.ofNullable(clazz.cast(this.applicationsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportWorkspaceImageRequest, T> g) {
        return obj -> g.apply((ImportWorkspaceImageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String ec2ImageId;
        private String ingestionProcess;
        private String imageName;
        private String imageDescription;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<String> applications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportWorkspaceImageRequest model) {
            super(model);
            this.ec2ImageId(model.ec2ImageId);
            this.ingestionProcess(model.ingestionProcess);
            this.imageName(model.imageName);
            this.imageDescription(model.imageDescription);
            this.tags(model.tags);
            this.applicationsWithStrings(model.applications);
        }

        public final String getEc2ImageId() {
            return this.ec2ImageId;
        }

        @Override
        public final Builder ec2ImageId(String ec2ImageId) {
            this.ec2ImageId = ec2ImageId;
            return this;
        }

        public final void setEc2ImageId(String ec2ImageId) {
            this.ec2ImageId = ec2ImageId;
        }

        public final String getIngestionProcess() {
            return this.ingestionProcess;
        }

        @Override
        public final Builder ingestionProcess(String ingestionProcess) {
            this.ingestionProcess = ingestionProcess;
            return this;
        }

        @Override
        public final Builder ingestionProcess(WorkspaceImageIngestionProcess ingestionProcess) {
            this.ingestionProcess(ingestionProcess == null ? null : ingestionProcess.toString());
            return this;
        }

        public final void setIngestionProcess(String ingestionProcess) {
            this.ingestionProcess = ingestionProcess;
        }

        public final String getImageName() {
            return this.imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public final String getImageDescription() {
            return this.imageDescription;
        }

        @Override
        public final Builder imageDescription(String imageDescription) {
            this.imageDescription = imageDescription;
            return this;
        }

        public final void setImageDescription(String imageDescription) {
            this.imageDescription = imageDescription;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<String> getApplications() {
            if (this.applications instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applications;
        }

        @Override
        public final Builder applicationsWithStrings(Collection<String> applications) {
            this.applications = ApplicationListCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationsWithStrings(String ... applications) {
            this.applicationsWithStrings(Arrays.asList(applications));
            return this;
        }

        @Override
        public final Builder applications(Collection<Application> applications) {
            this.applications = ApplicationListCopier.copyEnumToString(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Application ... applications) {
            this.applications(Arrays.asList(applications));
            return this;
        }

        public final void setApplications(Collection<String> applications) {
            this.applications = ApplicationListCopier.copy(applications);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportWorkspaceImageRequest build() {
            return new ImportWorkspaceImageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportWorkspaceImageRequest> {
        public Builder ec2ImageId(String var1);

        public Builder ingestionProcess(String var1);

        public Builder ingestionProcess(WorkspaceImageIngestionProcess var1);

        public Builder imageName(String var1);

        public Builder imageDescription(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder applicationsWithStrings(Collection<String> var1);

        public Builder applicationsWithStrings(String ... var1);

        public Builder applications(Collection<Application> var1);

        public Builder applications(Application ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

