/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ActivityType {
    DOCUMENT_CHECKED_IN("DOCUMENT_CHECKED_IN"),
    DOCUMENT_CHECKED_OUT("DOCUMENT_CHECKED_OUT"),
    DOCUMENT_RENAMED("DOCUMENT_RENAMED"),
    DOCUMENT_VERSION_UPLOADED("DOCUMENT_VERSION_UPLOADED"),
    DOCUMENT_VERSION_DELETED("DOCUMENT_VERSION_DELETED"),
    DOCUMENT_VERSION_VIEWED("DOCUMENT_VERSION_VIEWED"),
    DOCUMENT_VERSION_DOWNLOADED("DOCUMENT_VERSION_DOWNLOADED"),
    DOCUMENT_RECYCLED("DOCUMENT_RECYCLED"),
    DOCUMENT_RESTORED("DOCUMENT_RESTORED"),
    DOCUMENT_REVERTED("DOCUMENT_REVERTED"),
    DOCUMENT_SHARED("DOCUMENT_SHARED"),
    DOCUMENT_UNSHARED("DOCUMENT_UNSHARED"),
    DOCUMENT_SHARE_PERMISSION_CHANGED("DOCUMENT_SHARE_PERMISSION_CHANGED"),
    DOCUMENT_SHAREABLE_LINK_CREATED("DOCUMENT_SHAREABLE_LINK_CREATED"),
    DOCUMENT_SHAREABLE_LINK_REMOVED("DOCUMENT_SHAREABLE_LINK_REMOVED"),
    DOCUMENT_SHAREABLE_LINK_PERMISSION_CHANGED("DOCUMENT_SHAREABLE_LINK_PERMISSION_CHANGED"),
    DOCUMENT_MOVED("DOCUMENT_MOVED"),
    DOCUMENT_COMMENT_ADDED("DOCUMENT_COMMENT_ADDED"),
    DOCUMENT_COMMENT_DELETED("DOCUMENT_COMMENT_DELETED"),
    DOCUMENT_ANNOTATION_ADDED("DOCUMENT_ANNOTATION_ADDED"),
    DOCUMENT_ANNOTATION_DELETED("DOCUMENT_ANNOTATION_DELETED"),
    FOLDER_CREATED("FOLDER_CREATED"),
    FOLDER_DELETED("FOLDER_DELETED"),
    FOLDER_RENAMED("FOLDER_RENAMED"),
    FOLDER_RECYCLED("FOLDER_RECYCLED"),
    FOLDER_RESTORED("FOLDER_RESTORED"),
    FOLDER_SHARED("FOLDER_SHARED"),
    FOLDER_UNSHARED("FOLDER_UNSHARED"),
    FOLDER_SHARE_PERMISSION_CHANGED("FOLDER_SHARE_PERMISSION_CHANGED"),
    FOLDER_SHAREABLE_LINK_CREATED("FOLDER_SHAREABLE_LINK_CREATED"),
    FOLDER_SHAREABLE_LINK_REMOVED("FOLDER_SHAREABLE_LINK_REMOVED"),
    FOLDER_SHAREABLE_LINK_PERMISSION_CHANGED("FOLDER_SHAREABLE_LINK_PERMISSION_CHANGED"),
    FOLDER_MOVED("FOLDER_MOVED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ActivityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActivityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ActivityType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActivityType> knownValues() {
        return Stream.of(ActivityType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

