/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.LensReview;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLensReviewResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, UpdateLensReviewResponse> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(UpdateLensReviewResponse.getter(UpdateLensReviewResponse::workloadId)).setter(UpdateLensReviewResponse.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()}).build();
    private static final SdkField<LensReview> LENS_REVIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LensReview").getter(UpdateLensReviewResponse.getter(UpdateLensReviewResponse::lensReview)).setter(UpdateLensReviewResponse.setter(Builder::lensReview)).constructor(LensReview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensReview").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, LENS_REVIEW_FIELD));
    private final String workloadId;
    private final LensReview lensReview;

    private UpdateLensReviewResponse(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.lensReview = builder.lensReview;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    public final LensReview lensReview() {
        return this.lensReview;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensReview());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLensReviewResponse)) {
            return false;
        }
        UpdateLensReviewResponse other = (UpdateLensReviewResponse)((Object)obj);
        return Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.lensReview(), other.lensReview());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLensReviewResponse").add("WorkloadId", (Object)this.workloadId()).add("LensReview", (Object)this.lensReview()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "LensReview": {
                return Optional.ofNullable(clazz.cast(this.lensReview()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLensReviewResponse, T> g) {
        return obj -> g.apply((UpdateLensReviewResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private String workloadId;
        private LensReview lensReview;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLensReviewResponse model) {
            super(model);
            this.workloadId(model.workloadId);
            this.lensReview(model.lensReview);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        public final LensReview.Builder getLensReview() {
            return this.lensReview != null ? this.lensReview.toBuilder() : null;
        }

        @Override
        public final Builder lensReview(LensReview lensReview) {
            this.lensReview = lensReview;
            return this;
        }

        public final void setLensReview(LensReview.BuilderImpl lensReview) {
            this.lensReview = lensReview != null ? lensReview.build() : null;
        }

        @Override
        public UpdateLensReviewResponse build() {
            return new UpdateLensReviewResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLensReviewResponse> {
        public Builder workloadId(String var1);

        public Builder lensReview(LensReview var1);

        default public Builder lensReview(Consumer<LensReview.Builder> lensReview) {
            return this.lensReview((LensReview)((LensReview.Builder)LensReview.builder().applyMutation(lensReview)).build());
        }
    }
}

