/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.ComparisonOperator;
import software.amazon.awssdk.services.wafv2.model.FieldToMatch;
import software.amazon.awssdk.services.wafv2.model.TextTransformation;
import software.amazon.awssdk.services.wafv2.model.TextTransformationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SizeConstraintStatement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SizeConstraintStatement> {
    private static final SdkField<FieldToMatch> FIELD_TO_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FieldToMatch").getter(SizeConstraintStatement.getter(SizeConstraintStatement::fieldToMatch)).setter(SizeConstraintStatement.setter(Builder::fieldToMatch)).constructor(FieldToMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldToMatch").build()}).build();
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComparisonOperator").getter(SizeConstraintStatement.getter(SizeConstraintStatement::comparisonOperatorAsString)).setter(SizeConstraintStatement.setter(Builder::comparisonOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").build()}).build();
    private static final SdkField<Long> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Size").getter(SizeConstraintStatement.getter(SizeConstraintStatement::size)).setter(SizeConstraintStatement.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()}).build();
    private static final SdkField<List<TextTransformation>> TEXT_TRANSFORMATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TextTransformations").getter(SizeConstraintStatement.getter(SizeConstraintStatement::textTransformations)).setter(SizeConstraintStatement.setter(Builder::textTransformations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextTransformations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TextTransformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_TO_MATCH_FIELD, COMPARISON_OPERATOR_FIELD, SIZE_FIELD, TEXT_TRANSFORMATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final FieldToMatch fieldToMatch;
    private final String comparisonOperator;
    private final Long size;
    private final List<TextTransformation> textTransformations;

    private SizeConstraintStatement(BuilderImpl builder) {
        this.fieldToMatch = builder.fieldToMatch;
        this.comparisonOperator = builder.comparisonOperator;
        this.size = builder.size;
        this.textTransformations = builder.textTransformations;
    }

    public final FieldToMatch fieldToMatch() {
        return this.fieldToMatch;
    }

    public final ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(this.comparisonOperator);
    }

    public final String comparisonOperatorAsString() {
        return this.comparisonOperator;
    }

    public final Long size() {
        return this.size;
    }

    public final boolean hasTextTransformations() {
        return this.textTransformations != null && !(this.textTransformations instanceof SdkAutoConstructList);
    }

    public final List<TextTransformation> textTransformations() {
        return this.textTransformations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldToMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTextTransformations() ? this.textTransformations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SizeConstraintStatement)) {
            return false;
        }
        SizeConstraintStatement other = (SizeConstraintStatement)obj;
        return Objects.equals(this.fieldToMatch(), other.fieldToMatch()) && Objects.equals(this.comparisonOperatorAsString(), other.comparisonOperatorAsString()) && Objects.equals(this.size(), other.size()) && this.hasTextTransformations() == other.hasTextTransformations() && Objects.equals(this.textTransformations(), other.textTransformations());
    }

    public final String toString() {
        return ToString.builder((String)"SizeConstraintStatement").add("FieldToMatch", (Object)this.fieldToMatch()).add("ComparisonOperator", (Object)this.comparisonOperatorAsString()).add("Size", (Object)this.size()).add("TextTransformations", this.hasTextTransformations() ? this.textTransformations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldToMatch": {
                return Optional.ofNullable(clazz.cast(this.fieldToMatch()));
            }
            case "ComparisonOperator": {
                return Optional.ofNullable(clazz.cast(this.comparisonOperatorAsString()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "TextTransformations": {
                return Optional.ofNullable(clazz.cast(this.textTransformations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SizeConstraintStatement, T> g) {
        return obj -> g.apply((SizeConstraintStatement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FieldToMatch fieldToMatch;
        private String comparisonOperator;
        private Long size;
        private List<TextTransformation> textTransformations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SizeConstraintStatement model) {
            this.fieldToMatch(model.fieldToMatch);
            this.comparisonOperator(model.comparisonOperator);
            this.size(model.size);
            this.textTransformations(model.textTransformations);
        }

        public final FieldToMatch.Builder getFieldToMatch() {
            return this.fieldToMatch != null ? this.fieldToMatch.toBuilder() : null;
        }

        @Override
        public final Builder fieldToMatch(FieldToMatch fieldToMatch) {
            this.fieldToMatch = fieldToMatch;
            return this;
        }

        public final void setFieldToMatch(FieldToMatch.BuilderImpl fieldToMatch) {
            this.fieldToMatch = fieldToMatch != null ? fieldToMatch.build() : null;
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final Long getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        public final List<TextTransformation.Builder> getTextTransformations() {
            List<TextTransformation.Builder> result = TextTransformationsCopier.copyToBuilder(this.textTransformations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder textTransformations(Collection<TextTransformation> textTransformations) {
            this.textTransformations = TextTransformationsCopier.copy(textTransformations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textTransformations(TextTransformation ... textTransformations) {
            this.textTransformations(Arrays.asList(textTransformations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textTransformations(Consumer<TextTransformation.Builder> ... textTransformations) {
            this.textTransformations(Stream.of(textTransformations).map(c -> (TextTransformation)((TextTransformation.Builder)TextTransformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTextTransformations(Collection<TextTransformation.BuilderImpl> textTransformations) {
            this.textTransformations = TextTransformationsCopier.copyFromBuilder(textTransformations);
        }

        public SizeConstraintStatement build() {
            return new SizeConstraintStatement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SizeConstraintStatement> {
        public Builder fieldToMatch(FieldToMatch var1);

        default public Builder fieldToMatch(Consumer<FieldToMatch.Builder> fieldToMatch) {
            return this.fieldToMatch((FieldToMatch)((FieldToMatch.Builder)FieldToMatch.builder().applyMutation(fieldToMatch)).build());
        }

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperator var1);

        public Builder size(Long var1);

        public Builder textTransformations(Collection<TextTransformation> var1);

        public Builder textTransformations(TextTransformation ... var1);

        public Builder textTransformations(Consumer<TextTransformation.Builder> ... var1);
    }
}

