/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ResponseContentType {
    TEXT_PLAIN("TEXT_PLAIN"),
    TEXT_HTML("TEXT_HTML"),
    APPLICATION_JSON("APPLICATION_JSON"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ResponseContentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResponseContentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ResponseContentType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResponseContentType> knownValues() {
        return Stream.of(ResponseContentType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

