/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum JsonMatchScope {
    ALL("ALL"),
    KEY("KEY"),
    VALUE("VALUE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private JsonMatchScope(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JsonMatchScope fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(JsonMatchScope.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JsonMatchScope> knownValues() {
        return Stream.of(JsonMatchScope.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

