/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.LabelSummariesCopier;
import software.amazon.awssdk.services.wafv2.model.LabelSummary;
import software.amazon.awssdk.services.wafv2.model.RuleSummariesCopier;
import software.amazon.awssdk.services.wafv2.model.RuleSummary;
import software.amazon.awssdk.services.wafv2.model.Wafv2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeManagedRuleGroupResponse
extends Wafv2Response
implements ToCopyableBuilder<Builder, DescribeManagedRuleGroupResponse> {
    private static final SdkField<Long> CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Capacity").getter(DescribeManagedRuleGroupResponse.getter(DescribeManagedRuleGroupResponse::capacity)).setter(DescribeManagedRuleGroupResponse.setter(Builder::capacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()}).build();
    private static final SdkField<List<RuleSummary>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(DescribeManagedRuleGroupResponse.getter(DescribeManagedRuleGroupResponse::rules)).setter(DescribeManagedRuleGroupResponse.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LABEL_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelNamespace").getter(DescribeManagedRuleGroupResponse.getter(DescribeManagedRuleGroupResponse::labelNamespace)).setter(DescribeManagedRuleGroupResponse.setter(Builder::labelNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelNamespace").build()}).build();
    private static final SdkField<List<LabelSummary>> AVAILABLE_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailableLabels").getter(DescribeManagedRuleGroupResponse.getter(DescribeManagedRuleGroupResponse::availableLabels)).setter(DescribeManagedRuleGroupResponse.setter(Builder::availableLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableLabels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LabelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LabelSummary>> CONSUMED_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConsumedLabels").getter(DescribeManagedRuleGroupResponse.getter(DescribeManagedRuleGroupResponse::consumedLabels)).setter(DescribeManagedRuleGroupResponse.setter(Builder::consumedLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedLabels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LabelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_FIELD, RULES_FIELD, LABEL_NAMESPACE_FIELD, AVAILABLE_LABELS_FIELD, CONSUMED_LABELS_FIELD));
    private final Long capacity;
    private final List<RuleSummary> rules;
    private final String labelNamespace;
    private final List<LabelSummary> availableLabels;
    private final List<LabelSummary> consumedLabels;

    private DescribeManagedRuleGroupResponse(BuilderImpl builder) {
        super(builder);
        this.capacity = builder.capacity;
        this.rules = builder.rules;
        this.labelNamespace = builder.labelNamespace;
        this.availableLabels = builder.availableLabels;
        this.consumedLabels = builder.consumedLabels;
    }

    public final Long capacity() {
        return this.capacity;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<RuleSummary> rules() {
        return this.rules;
    }

    public final String labelNamespace() {
        return this.labelNamespace;
    }

    public final boolean hasAvailableLabels() {
        return this.availableLabels != null && !(this.availableLabels instanceof SdkAutoConstructList);
    }

    public final List<LabelSummary> availableLabels() {
        return this.availableLabels;
    }

    public final boolean hasConsumedLabels() {
        return this.consumedLabels != null && !(this.consumedLabels instanceof SdkAutoConstructList);
    }

    public final List<LabelSummary> consumedLabels() {
        return this.consumedLabels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.capacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.labelNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailableLabels() ? this.availableLabels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConsumedLabels() ? this.consumedLabels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeManagedRuleGroupResponse)) {
            return false;
        }
        DescribeManagedRuleGroupResponse other = (DescribeManagedRuleGroupResponse)((Object)obj);
        return Objects.equals(this.capacity(), other.capacity()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.labelNamespace(), other.labelNamespace()) && this.hasAvailableLabels() == other.hasAvailableLabels() && Objects.equals(this.availableLabels(), other.availableLabels()) && this.hasConsumedLabels() == other.hasConsumedLabels() && Objects.equals(this.consumedLabels(), other.consumedLabels());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeManagedRuleGroupResponse").add("Capacity", (Object)this.capacity()).add("Rules", this.hasRules() ? this.rules() : null).add("LabelNamespace", (Object)this.labelNamespace()).add("AvailableLabels", this.hasAvailableLabels() ? this.availableLabels() : null).add("ConsumedLabels", this.hasConsumedLabels() ? this.consumedLabels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Capacity": {
                return Optional.ofNullable(clazz.cast(this.capacity()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "LabelNamespace": {
                return Optional.ofNullable(clazz.cast(this.labelNamespace()));
            }
            case "AvailableLabels": {
                return Optional.ofNullable(clazz.cast(this.availableLabels()));
            }
            case "ConsumedLabels": {
                return Optional.ofNullable(clazz.cast(this.consumedLabels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeManagedRuleGroupResponse, T> g) {
        return obj -> g.apply((DescribeManagedRuleGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Response.BuilderImpl
    implements Builder {
        private Long capacity;
        private List<RuleSummary> rules = DefaultSdkAutoConstructList.getInstance();
        private String labelNamespace;
        private List<LabelSummary> availableLabels = DefaultSdkAutoConstructList.getInstance();
        private List<LabelSummary> consumedLabels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeManagedRuleGroupResponse model) {
            super(model);
            this.capacity(model.capacity);
            this.rules(model.rules);
            this.labelNamespace(model.labelNamespace);
            this.availableLabels(model.availableLabels);
            this.consumedLabels(model.consumedLabels);
        }

        public final Long getCapacity() {
            return this.capacity;
        }

        @Override
        public final Builder capacity(Long capacity) {
            this.capacity = capacity;
            return this;
        }

        public final void setCapacity(Long capacity) {
            this.capacity = capacity;
        }

        public final List<RuleSummary.Builder> getRules() {
            List<RuleSummary.Builder> result = RuleSummariesCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder rules(Collection<RuleSummary> rules) {
            this.rules = RuleSummariesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(RuleSummary ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<RuleSummary.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (RuleSummary)((RuleSummary.Builder)RuleSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<RuleSummary.BuilderImpl> rules) {
            this.rules = RuleSummariesCopier.copyFromBuilder(rules);
        }

        public final String getLabelNamespace() {
            return this.labelNamespace;
        }

        @Override
        public final Builder labelNamespace(String labelNamespace) {
            this.labelNamespace = labelNamespace;
            return this;
        }

        public final void setLabelNamespace(String labelNamespace) {
            this.labelNamespace = labelNamespace;
        }

        public final List<LabelSummary.Builder> getAvailableLabels() {
            List<LabelSummary.Builder> result = LabelSummariesCopier.copyToBuilder(this.availableLabels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder availableLabels(Collection<LabelSummary> availableLabels) {
            this.availableLabels = LabelSummariesCopier.copy(availableLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableLabels(LabelSummary ... availableLabels) {
            this.availableLabels(Arrays.asList(availableLabels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableLabels(Consumer<LabelSummary.Builder> ... availableLabels) {
            this.availableLabels(Stream.of(availableLabels).map(c -> (LabelSummary)((LabelSummary.Builder)LabelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAvailableLabels(Collection<LabelSummary.BuilderImpl> availableLabels) {
            this.availableLabels = LabelSummariesCopier.copyFromBuilder(availableLabels);
        }

        public final List<LabelSummary.Builder> getConsumedLabels() {
            List<LabelSummary.Builder> result = LabelSummariesCopier.copyToBuilder(this.consumedLabels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder consumedLabels(Collection<LabelSummary> consumedLabels) {
            this.consumedLabels = LabelSummariesCopier.copy(consumedLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedLabels(LabelSummary ... consumedLabels) {
            this.consumedLabels(Arrays.asList(consumedLabels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedLabels(Consumer<LabelSummary.Builder> ... consumedLabels) {
            this.consumedLabels(Stream.of(consumedLabels).map(c -> (LabelSummary)((LabelSummary.Builder)LabelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConsumedLabels(Collection<LabelSummary.BuilderImpl> consumedLabels) {
            this.consumedLabels = LabelSummariesCopier.copyFromBuilder(consumedLabels);
        }

        @Override
        public DescribeManagedRuleGroupResponse build() {
            return new DescribeManagedRuleGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Wafv2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeManagedRuleGroupResponse> {
        public Builder capacity(Long var1);

        public Builder rules(Collection<RuleSummary> var1);

        public Builder rules(RuleSummary ... var1);

        public Builder rules(Consumer<RuleSummary.Builder> ... var1);

        public Builder labelNamespace(String var1);

        public Builder availableLabels(Collection<LabelSummary> var1);

        public Builder availableLabels(LabelSummary ... var1);

        public Builder availableLabels(Consumer<LabelSummary.Builder> ... var1);

        public Builder consumedLabels(Collection<LabelSummary> var1);

        public Builder consumedLabels(LabelSummary ... var1);

        public Builder consumedLabels(Consumer<LabelSummary.Builder> ... var1);
    }
}

