/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.XssMatchTuple;
import software.amazon.awssdk.services.waf.model.XssMatchTuplesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class XssMatchSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, XssMatchSet> {
    private static final SdkField<String> XSS_MATCH_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("XssMatchSetId").getter(XssMatchSet.getter(XssMatchSet::xssMatchSetId)).setter(XssMatchSet.setter(Builder::xssMatchSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XssMatchSetId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(XssMatchSet.getter(XssMatchSet::name)).setter(XssMatchSet.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<XssMatchTuple>> XSS_MATCH_TUPLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("XssMatchTuples").getter(XssMatchSet.getter(XssMatchSet::xssMatchTuples)).setter(XssMatchSet.setter(Builder::xssMatchTuples)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XssMatchTuples").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(XssMatchTuple::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(XSS_MATCH_SET_ID_FIELD, NAME_FIELD, XSS_MATCH_TUPLES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String xssMatchSetId;
    private final String name;
    private final List<XssMatchTuple> xssMatchTuples;

    private XssMatchSet(BuilderImpl builder) {
        this.xssMatchSetId = builder.xssMatchSetId;
        this.name = builder.name;
        this.xssMatchTuples = builder.xssMatchTuples;
    }

    public final String xssMatchSetId() {
        return this.xssMatchSetId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasXssMatchTuples() {
        return this.xssMatchTuples != null && !(this.xssMatchTuples instanceof SdkAutoConstructList);
    }

    public final List<XssMatchTuple> xssMatchTuples() {
        return this.xssMatchTuples;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.xssMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasXssMatchTuples() ? this.xssMatchTuples() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XssMatchSet)) {
            return false;
        }
        XssMatchSet other = (XssMatchSet)obj;
        return Objects.equals(this.xssMatchSetId(), other.xssMatchSetId()) && Objects.equals(this.name(), other.name()) && this.hasXssMatchTuples() == other.hasXssMatchTuples() && Objects.equals(this.xssMatchTuples(), other.xssMatchTuples());
    }

    public final String toString() {
        return ToString.builder((String)"XssMatchSet").add("XssMatchSetId", (Object)this.xssMatchSetId()).add("Name", (Object)this.name()).add("XssMatchTuples", this.hasXssMatchTuples() ? this.xssMatchTuples() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "XssMatchSetId": {
                return Optional.ofNullable(clazz.cast(this.xssMatchSetId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "XssMatchTuples": {
                return Optional.ofNullable(clazz.cast(this.xssMatchTuples()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<XssMatchSet, T> g) {
        return obj -> g.apply((XssMatchSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String xssMatchSetId;
        private String name;
        private List<XssMatchTuple> xssMatchTuples = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(XssMatchSet model) {
            this.xssMatchSetId(model.xssMatchSetId);
            this.name(model.name);
            this.xssMatchTuples(model.xssMatchTuples);
        }

        public final String getXssMatchSetId() {
            return this.xssMatchSetId;
        }

        @Override
        public final Builder xssMatchSetId(String xssMatchSetId) {
            this.xssMatchSetId = xssMatchSetId;
            return this;
        }

        public final void setXssMatchSetId(String xssMatchSetId) {
            this.xssMatchSetId = xssMatchSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final List<XssMatchTuple.Builder> getXssMatchTuples() {
            List<XssMatchTuple.Builder> result = XssMatchTuplesCopier.copyToBuilder(this.xssMatchTuples);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder xssMatchTuples(Collection<XssMatchTuple> xssMatchTuples) {
            this.xssMatchTuples = XssMatchTuplesCopier.copy(xssMatchTuples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder xssMatchTuples(XssMatchTuple ... xssMatchTuples) {
            this.xssMatchTuples(Arrays.asList(xssMatchTuples));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder xssMatchTuples(Consumer<XssMatchTuple.Builder> ... xssMatchTuples) {
            this.xssMatchTuples(Stream.of(xssMatchTuples).map(c -> (XssMatchTuple)((XssMatchTuple.Builder)XssMatchTuple.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setXssMatchTuples(Collection<XssMatchTuple.BuilderImpl> xssMatchTuples) {
            this.xssMatchTuples = XssMatchTuplesCopier.copyFromBuilder(xssMatchTuples);
        }

        public XssMatchSet build() {
            return new XssMatchSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, XssMatchSet> {
        public Builder xssMatchSetId(String var1);

        public Builder name(String var1);

        public Builder xssMatchTuples(Collection<XssMatchTuple> var1);

        public Builder xssMatchTuples(XssMatchTuple ... var1);

        public Builder xssMatchTuples(Consumer<XssMatchTuple.Builder> ... var1);
    }
}

