/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.Tag;
import software.amazon.awssdk.services.waf.model.TagListCopier;
import software.amazon.awssdk.services.waf.model.WafAction;
import software.amazon.awssdk.services.waf.model.WafRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWebAclRequest
extends WafRequest
implements ToCopyableBuilder<Builder, CreateWebAclRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateWebAclRequest.getter(CreateWebAclRequest::name)).setter(CreateWebAclRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(CreateWebAclRequest.getter(CreateWebAclRequest::metricName)).setter(CreateWebAclRequest.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<WafAction> DEFAULT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultAction").getter(CreateWebAclRequest.getter(CreateWebAclRequest::defaultAction)).setter(CreateWebAclRequest.setter(Builder::defaultAction)).constructor(WafAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAction").build()}).build();
    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeToken").getter(CreateWebAclRequest.getter(CreateWebAclRequest::changeToken)).setter(CreateWebAclRequest.setter(Builder::changeToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateWebAclRequest.getter(CreateWebAclRequest::tags)).setter(CreateWebAclRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, METRIC_NAME_FIELD, DEFAULT_ACTION_FIELD, CHANGE_TOKEN_FIELD, TAGS_FIELD));
    private final String name;
    private final String metricName;
    private final WafAction defaultAction;
    private final String changeToken;
    private final List<Tag> tags;

    private CreateWebAclRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.metricName = builder.metricName;
        this.defaultAction = builder.defaultAction;
        this.changeToken = builder.changeToken;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final WafAction defaultAction() {
        return this.defaultAction;
    }

    public final String changeToken() {
        return this.changeToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWebAclRequest)) {
            return false;
        }
        CreateWebAclRequest other = (CreateWebAclRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.defaultAction(), other.defaultAction()) && Objects.equals(this.changeToken(), other.changeToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWebAclRequest").add("Name", (Object)this.name()).add("MetricName", (Object)this.metricName()).add("DefaultAction", (Object)this.defaultAction()).add("ChangeToken", (Object)this.changeToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "DefaultAction": {
                return Optional.ofNullable(clazz.cast(this.defaultAction()));
            }
            case "ChangeToken": {
                return Optional.ofNullable(clazz.cast(this.changeToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWebAclRequest, T> g) {
        return obj -> g.apply((CreateWebAclRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafRequest.BuilderImpl
    implements Builder {
        private String name;
        private String metricName;
        private WafAction defaultAction;
        private String changeToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWebAclRequest model) {
            super(model);
            this.name(model.name);
            this.metricName(model.metricName);
            this.defaultAction(model.defaultAction);
            this.changeToken(model.changeToken);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final WafAction.Builder getDefaultAction() {
            return this.defaultAction != null ? this.defaultAction.toBuilder() : null;
        }

        @Override
        public final Builder defaultAction(WafAction defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        public final void setDefaultAction(WafAction.BuilderImpl defaultAction) {
            this.defaultAction = defaultAction != null ? defaultAction.build() : null;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWebAclRequest build() {
            return new CreateWebAclRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WafRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWebAclRequest> {
        public Builder name(String var1);

        public Builder metricName(String var1);

        public Builder defaultAction(WafAction var1);

        default public Builder defaultAction(Consumer<WafAction.Builder> defaultAction) {
            return this.defaultAction((WafAction)((WafAction.Builder)WafAction.builder().applyMutation(defaultAction)).build());
        }

        public Builder changeToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

