/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ParallelDataFormat {
    TSV("TSV"),
    CSV("CSV"),
    TMX("TMX"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ParallelDataFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ParallelDataFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ParallelDataFormat.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ParallelDataFormat> knownValues() {
        return Stream.of(ParallelDataFormat.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

