/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MeasureValueType {
    DOUBLE("DOUBLE"),
    BIGINT("BIGINT"),
    VARCHAR("VARCHAR"),
    BOOLEAN("BOOLEAN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MeasureValueType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MeasureValueType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MeasureValueType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MeasureValueType> knownValues() {
        return Stream.of(MeasureValueType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

