/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CanaryCodeInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CanaryCodeInput> {
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Bucket").getter(CanaryCodeInput.getter(CanaryCodeInput::s3Bucket)).setter(CanaryCodeInput.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()}).build();
    private static final SdkField<String> S3_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Key").getter(CanaryCodeInput.getter(CanaryCodeInput::s3Key)).setter(CanaryCodeInput.setter(Builder::s3Key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Key").build()}).build();
    private static final SdkField<String> S3_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Version").getter(CanaryCodeInput.getter(CanaryCodeInput::s3Version)).setter(CanaryCodeInput.setter(Builder::s3Version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Version").build()}).build();
    private static final SdkField<SdkBytes> ZIP_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("ZipFile").getter(CanaryCodeInput.getter(CanaryCodeInput::zipFile)).setter(CanaryCodeInput.setter(Builder::zipFile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZipFile").build()}).build();
    private static final SdkField<String> HANDLER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Handler").getter(CanaryCodeInput.getter(CanaryCodeInput::handler)).setter(CanaryCodeInput.setter(Builder::handler)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Handler").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_FIELD, S3_KEY_FIELD, S3_VERSION_FIELD, ZIP_FILE_FIELD, HANDLER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3Bucket;
    private final String s3Key;
    private final String s3Version;
    private final SdkBytes zipFile;
    private final String handler;

    private CanaryCodeInput(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
        this.s3Version = builder.s3Version;
        this.zipFile = builder.zipFile;
        this.handler = builder.handler;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public final String s3Key() {
        return this.s3Key;
    }

    public final String s3Version() {
        return this.s3Version;
    }

    public final SdkBytes zipFile() {
        return this.zipFile;
    }

    public final String handler() {
        return this.handler;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Key());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Version());
        hashCode = 31 * hashCode + Objects.hashCode(this.zipFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.handler());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryCodeInput)) {
            return false;
        }
        CanaryCodeInput other = (CanaryCodeInput)obj;
        return Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3Key(), other.s3Key()) && Objects.equals(this.s3Version(), other.s3Version()) && Objects.equals(this.zipFile(), other.zipFile()) && Objects.equals(this.handler(), other.handler());
    }

    public final String toString() {
        return ToString.builder((String)"CanaryCodeInput").add("S3Bucket", (Object)this.s3Bucket()).add("S3Key", (Object)this.s3Key()).add("S3Version", (Object)this.s3Version()).add("ZipFile", (Object)this.zipFile()).add("Handler", (Object)this.handler()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "S3Key": {
                return Optional.ofNullable(clazz.cast(this.s3Key()));
            }
            case "S3Version": {
                return Optional.ofNullable(clazz.cast(this.s3Version()));
            }
            case "ZipFile": {
                return Optional.ofNullable(clazz.cast(this.zipFile()));
            }
            case "Handler": {
                return Optional.ofNullable(clazz.cast(this.handler()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CanaryCodeInput, T> g) {
        return obj -> g.apply((CanaryCodeInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Bucket;
        private String s3Key;
        private String s3Version;
        private SdkBytes zipFile;
        private String handler;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryCodeInput model) {
            this.s3Bucket(model.s3Bucket);
            this.s3Key(model.s3Key);
            this.s3Version(model.s3Version);
            this.zipFile(model.zipFile);
            this.handler(model.handler);
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Key() {
            return this.s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        public final String getS3Version() {
            return this.s3Version;
        }

        @Override
        public final Builder s3Version(String s3Version) {
            this.s3Version = s3Version;
            return this;
        }

        public final void setS3Version(String s3Version) {
            this.s3Version = s3Version;
        }

        public final ByteBuffer getZipFile() {
            return this.zipFile == null ? null : this.zipFile.asByteBuffer();
        }

        @Override
        public final Builder zipFile(SdkBytes zipFile) {
            this.zipFile = zipFile;
            return this;
        }

        public final void setZipFile(ByteBuffer zipFile) {
            this.zipFile(zipFile == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)zipFile));
        }

        public final String getHandler() {
            return this.handler;
        }

        @Override
        public final Builder handler(String handler) {
            this.handler = handler;
            return this;
        }

        public final void setHandler(String handler) {
            this.handler = handler;
        }

        public CanaryCodeInput build() {
            return new CanaryCodeInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CanaryCodeInput> {
        public Builder s3Bucket(String var1);

        public Builder s3Key(String var1);

        public Builder s3Version(String var1);

        public Builder zipFile(SdkBytes var1);

        public Builder handler(String var1);
    }
}

