/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.swf.SwfAsyncClient;
import software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsRequest;
import software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsResponse;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionInfo;

public class ListOpenWorkflowExecutionsPublisher
implements SdkPublisher<ListOpenWorkflowExecutionsResponse> {
    private final SwfAsyncClient client;
    private final ListOpenWorkflowExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOpenWorkflowExecutionsPublisher(SwfAsyncClient client, ListOpenWorkflowExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOpenWorkflowExecutionsPublisher(SwfAsyncClient client, ListOpenWorkflowExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOpenWorkflowExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOpenWorkflowExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkflowExecutionInfo> executionInfos() {
        Function<ListOpenWorkflowExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.executionInfos() != null) {
                return response.executionInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOpenWorkflowExecutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOpenWorkflowExecutionsResponseFetcher
    implements AsyncPageFetcher<ListOpenWorkflowExecutionsResponse> {
        private ListOpenWorkflowExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListOpenWorkflowExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<ListOpenWorkflowExecutionsResponse> nextPage(ListOpenWorkflowExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListOpenWorkflowExecutionsPublisher.this.client.listOpenWorkflowExecutions(ListOpenWorkflowExecutionsPublisher.this.firstRequest);
            }
            return ListOpenWorkflowExecutionsPublisher.this.client.listOpenWorkflowExecutions((ListOpenWorkflowExecutionsRequest)((Object)ListOpenWorkflowExecutionsPublisher.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

