/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.storagegateway.StorageGatewayClient;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsResponse;
import software.amazon.awssdk.services.storagegateway.model.TapeRecoveryPointInfo;

public class DescribeTapeRecoveryPointsIterable
implements SdkIterable<DescribeTapeRecoveryPointsResponse> {
    private final StorageGatewayClient client;
    private final DescribeTapeRecoveryPointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTapeRecoveryPointsIterable(StorageGatewayClient client, DescribeTapeRecoveryPointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeTapeRecoveryPointsResponseFetcher();
    }

    public Iterator<DescribeTapeRecoveryPointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TapeRecoveryPointInfo> tapeRecoveryPointInfos() {
        Function<DescribeTapeRecoveryPointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tapeRecoveryPointInfos() != null) {
                return response.tapeRecoveryPointInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeTapeRecoveryPointsResponseFetcher
    implements SyncPageFetcher<DescribeTapeRecoveryPointsResponse> {
        private DescribeTapeRecoveryPointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTapeRecoveryPointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeTapeRecoveryPointsResponse nextPage(DescribeTapeRecoveryPointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTapeRecoveryPointsIterable.this.client.describeTapeRecoveryPoints(DescribeTapeRecoveryPointsIterable.this.firstRequest);
            }
            return DescribeTapeRecoveryPointsIterable.this.client.describeTapeRecoveryPoints((DescribeTapeRecoveryPointsRequest)((Object)DescribeTapeRecoveryPointsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

