/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSnapshotFromVolumeRecoveryPointResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, CreateSnapshotFromVolumeRecoveryPointResponse> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(CreateSnapshotFromVolumeRecoveryPointResponse.getter(CreateSnapshotFromVolumeRecoveryPointResponse::snapshotId)).setter(CreateSnapshotFromVolumeRecoveryPointResponse.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()}).build();
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeARN").getter(CreateSnapshotFromVolumeRecoveryPointResponse.getter(CreateSnapshotFromVolumeRecoveryPointResponse::volumeARN)).setter(CreateSnapshotFromVolumeRecoveryPointResponse.setter(Builder::volumeARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARN").build()}).build();
    private static final SdkField<String> VOLUME_RECOVERY_POINT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeRecoveryPointTime").getter(CreateSnapshotFromVolumeRecoveryPointResponse.getter(CreateSnapshotFromVolumeRecoveryPointResponse::volumeRecoveryPointTime)).setter(CreateSnapshotFromVolumeRecoveryPointResponse.setter(Builder::volumeRecoveryPointTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeRecoveryPointTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD, VOLUME_ARN_FIELD, VOLUME_RECOVERY_POINT_TIME_FIELD));
    private final String snapshotId;
    private final String volumeARN;
    private final String volumeRecoveryPointTime;

    private CreateSnapshotFromVolumeRecoveryPointResponse(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.volumeARN = builder.volumeARN;
        this.volumeRecoveryPointTime = builder.volumeRecoveryPointTime;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final String volumeARN() {
        return this.volumeARN;
    }

    public final String volumeRecoveryPointTime() {
        return this.volumeRecoveryPointTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeRecoveryPointTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotFromVolumeRecoveryPointResponse)) {
            return false;
        }
        CreateSnapshotFromVolumeRecoveryPointResponse other = (CreateSnapshotFromVolumeRecoveryPointResponse)((Object)obj);
        return Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.volumeARN(), other.volumeARN()) && Objects.equals(this.volumeRecoveryPointTime(), other.volumeRecoveryPointTime());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSnapshotFromVolumeRecoveryPointResponse").add("SnapshotId", (Object)this.snapshotId()).add("VolumeARN", (Object)this.volumeARN()).add("VolumeRecoveryPointTime", (Object)this.volumeRecoveryPointTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "VolumeARN": {
                return Optional.ofNullable(clazz.cast(this.volumeARN()));
            }
            case "VolumeRecoveryPointTime": {
                return Optional.ofNullable(clazz.cast(this.volumeRecoveryPointTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSnapshotFromVolumeRecoveryPointResponse, T> g) {
        return obj -> g.apply((CreateSnapshotFromVolumeRecoveryPointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private String snapshotId;
        private String volumeARN;
        private String volumeRecoveryPointTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotFromVolumeRecoveryPointResponse model) {
            super(model);
            this.snapshotId(model.snapshotId);
            this.volumeARN(model.volumeARN);
            this.volumeRecoveryPointTime(model.volumeRecoveryPointTime);
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getVolumeARN() {
            return this.volumeARN;
        }

        @Override
        public final Builder volumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
            return this;
        }

        public final void setVolumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
        }

        public final String getVolumeRecoveryPointTime() {
            return this.volumeRecoveryPointTime;
        }

        @Override
        public final Builder volumeRecoveryPointTime(String volumeRecoveryPointTime) {
            this.volumeRecoveryPointTime = volumeRecoveryPointTime;
            return this;
        }

        public final void setVolumeRecoveryPointTime(String volumeRecoveryPointTime) {
            this.volumeRecoveryPointTime = volumeRecoveryPointTime;
        }

        @Override
        public CreateSnapshotFromVolumeRecoveryPointResponse build() {
            return new CreateSnapshotFromVolumeRecoveryPointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSnapshotFromVolumeRecoveryPointResponse> {
        public Builder snapshotId(String var1);

        public Builder volumeARN(String var1);

        public Builder volumeRecoveryPointTime(String var1);
    }
}

