/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.DaysOfWeekCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BandwidthRateLimitInterval
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BandwidthRateLimitInterval> {
    private static final SdkField<Integer> START_HOUR_OF_DAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StartHourOfDay").getter(BandwidthRateLimitInterval.getter(BandwidthRateLimitInterval::startHourOfDay)).setter(BandwidthRateLimitInterval.setter(Builder::startHourOfDay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartHourOfDay").build()}).build();
    private static final SdkField<Integer> START_MINUTE_OF_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StartMinuteOfHour").getter(BandwidthRateLimitInterval.getter(BandwidthRateLimitInterval::startMinuteOfHour)).setter(BandwidthRateLimitInterval.setter(Builder::startMinuteOfHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartMinuteOfHour").build()}).build();
    private static final SdkField<Integer> END_HOUR_OF_DAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EndHourOfDay").getter(BandwidthRateLimitInterval.getter(BandwidthRateLimitInterval::endHourOfDay)).setter(BandwidthRateLimitInterval.setter(Builder::endHourOfDay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndHourOfDay").build()}).build();
    private static final SdkField<Integer> END_MINUTE_OF_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EndMinuteOfHour").getter(BandwidthRateLimitInterval.getter(BandwidthRateLimitInterval::endMinuteOfHour)).setter(BandwidthRateLimitInterval.setter(Builder::endMinuteOfHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndMinuteOfHour").build()}).build();
    private static final SdkField<List<Integer>> DAYS_OF_WEEK_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DaysOfWeek").getter(BandwidthRateLimitInterval.getter(BandwidthRateLimitInterval::daysOfWeek)).setter(BandwidthRateLimitInterval.setter(Builder::daysOfWeek)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DaysOfWeek").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> AVERAGE_UPLOAD_RATE_LIMIT_IN_BITS_PER_SEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AverageUploadRateLimitInBitsPerSec").getter(BandwidthRateLimitInterval.getter(BandwidthRateLimitInterval::averageUploadRateLimitInBitsPerSec)).setter(BandwidthRateLimitInterval.setter(Builder::averageUploadRateLimitInBitsPerSec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageUploadRateLimitInBitsPerSec").build()}).build();
    private static final SdkField<Long> AVERAGE_DOWNLOAD_RATE_LIMIT_IN_BITS_PER_SEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AverageDownloadRateLimitInBitsPerSec").getter(BandwidthRateLimitInterval.getter(BandwidthRateLimitInterval::averageDownloadRateLimitInBitsPerSec)).setter(BandwidthRateLimitInterval.setter(Builder::averageDownloadRateLimitInBitsPerSec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageDownloadRateLimitInBitsPerSec").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_HOUR_OF_DAY_FIELD, START_MINUTE_OF_HOUR_FIELD, END_HOUR_OF_DAY_FIELD, END_MINUTE_OF_HOUR_FIELD, DAYS_OF_WEEK_FIELD, AVERAGE_UPLOAD_RATE_LIMIT_IN_BITS_PER_SEC_FIELD, AVERAGE_DOWNLOAD_RATE_LIMIT_IN_BITS_PER_SEC_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer startHourOfDay;
    private final Integer startMinuteOfHour;
    private final Integer endHourOfDay;
    private final Integer endMinuteOfHour;
    private final List<Integer> daysOfWeek;
    private final Long averageUploadRateLimitInBitsPerSec;
    private final Long averageDownloadRateLimitInBitsPerSec;

    private BandwidthRateLimitInterval(BuilderImpl builder) {
        this.startHourOfDay = builder.startHourOfDay;
        this.startMinuteOfHour = builder.startMinuteOfHour;
        this.endHourOfDay = builder.endHourOfDay;
        this.endMinuteOfHour = builder.endMinuteOfHour;
        this.daysOfWeek = builder.daysOfWeek;
        this.averageUploadRateLimitInBitsPerSec = builder.averageUploadRateLimitInBitsPerSec;
        this.averageDownloadRateLimitInBitsPerSec = builder.averageDownloadRateLimitInBitsPerSec;
    }

    public final Integer startHourOfDay() {
        return this.startHourOfDay;
    }

    public final Integer startMinuteOfHour() {
        return this.startMinuteOfHour;
    }

    public final Integer endHourOfDay() {
        return this.endHourOfDay;
    }

    public final Integer endMinuteOfHour() {
        return this.endMinuteOfHour;
    }

    public final boolean hasDaysOfWeek() {
        return this.daysOfWeek != null && !(this.daysOfWeek instanceof SdkAutoConstructList);
    }

    public final List<Integer> daysOfWeek() {
        return this.daysOfWeek;
    }

    public final Long averageUploadRateLimitInBitsPerSec() {
        return this.averageUploadRateLimitInBitsPerSec;
    }

    public final Long averageDownloadRateLimitInBitsPerSec() {
        return this.averageDownloadRateLimitInBitsPerSec;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startHourOfDay());
        hashCode = 31 * hashCode + Objects.hashCode(this.startMinuteOfHour());
        hashCode = 31 * hashCode + Objects.hashCode(this.endHourOfDay());
        hashCode = 31 * hashCode + Objects.hashCode(this.endMinuteOfHour());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDaysOfWeek() ? this.daysOfWeek() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.averageUploadRateLimitInBitsPerSec());
        hashCode = 31 * hashCode + Objects.hashCode(this.averageDownloadRateLimitInBitsPerSec());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BandwidthRateLimitInterval)) {
            return false;
        }
        BandwidthRateLimitInterval other = (BandwidthRateLimitInterval)obj;
        return Objects.equals(this.startHourOfDay(), other.startHourOfDay()) && Objects.equals(this.startMinuteOfHour(), other.startMinuteOfHour()) && Objects.equals(this.endHourOfDay(), other.endHourOfDay()) && Objects.equals(this.endMinuteOfHour(), other.endMinuteOfHour()) && this.hasDaysOfWeek() == other.hasDaysOfWeek() && Objects.equals(this.daysOfWeek(), other.daysOfWeek()) && Objects.equals(this.averageUploadRateLimitInBitsPerSec(), other.averageUploadRateLimitInBitsPerSec()) && Objects.equals(this.averageDownloadRateLimitInBitsPerSec(), other.averageDownloadRateLimitInBitsPerSec());
    }

    public final String toString() {
        return ToString.builder((String)"BandwidthRateLimitInterval").add("StartHourOfDay", (Object)this.startHourOfDay()).add("StartMinuteOfHour", (Object)this.startMinuteOfHour()).add("EndHourOfDay", (Object)this.endHourOfDay()).add("EndMinuteOfHour", (Object)this.endMinuteOfHour()).add("DaysOfWeek", this.hasDaysOfWeek() ? this.daysOfWeek() : null).add("AverageUploadRateLimitInBitsPerSec", (Object)this.averageUploadRateLimitInBitsPerSec()).add("AverageDownloadRateLimitInBitsPerSec", (Object)this.averageDownloadRateLimitInBitsPerSec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartHourOfDay": {
                return Optional.ofNullable(clazz.cast(this.startHourOfDay()));
            }
            case "StartMinuteOfHour": {
                return Optional.ofNullable(clazz.cast(this.startMinuteOfHour()));
            }
            case "EndHourOfDay": {
                return Optional.ofNullable(clazz.cast(this.endHourOfDay()));
            }
            case "EndMinuteOfHour": {
                return Optional.ofNullable(clazz.cast(this.endMinuteOfHour()));
            }
            case "DaysOfWeek": {
                return Optional.ofNullable(clazz.cast(this.daysOfWeek()));
            }
            case "AverageUploadRateLimitInBitsPerSec": {
                return Optional.ofNullable(clazz.cast(this.averageUploadRateLimitInBitsPerSec()));
            }
            case "AverageDownloadRateLimitInBitsPerSec": {
                return Optional.ofNullable(clazz.cast(this.averageDownloadRateLimitInBitsPerSec()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BandwidthRateLimitInterval, T> g) {
        return obj -> g.apply((BandwidthRateLimitInterval)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer startHourOfDay;
        private Integer startMinuteOfHour;
        private Integer endHourOfDay;
        private Integer endMinuteOfHour;
        private List<Integer> daysOfWeek = DefaultSdkAutoConstructList.getInstance();
        private Long averageUploadRateLimitInBitsPerSec;
        private Long averageDownloadRateLimitInBitsPerSec;

        private BuilderImpl() {
        }

        private BuilderImpl(BandwidthRateLimitInterval model) {
            this.startHourOfDay(model.startHourOfDay);
            this.startMinuteOfHour(model.startMinuteOfHour);
            this.endHourOfDay(model.endHourOfDay);
            this.endMinuteOfHour(model.endMinuteOfHour);
            this.daysOfWeek(model.daysOfWeek);
            this.averageUploadRateLimitInBitsPerSec(model.averageUploadRateLimitInBitsPerSec);
            this.averageDownloadRateLimitInBitsPerSec(model.averageDownloadRateLimitInBitsPerSec);
        }

        public final Integer getStartHourOfDay() {
            return this.startHourOfDay;
        }

        @Override
        public final Builder startHourOfDay(Integer startHourOfDay) {
            this.startHourOfDay = startHourOfDay;
            return this;
        }

        public final void setStartHourOfDay(Integer startHourOfDay) {
            this.startHourOfDay = startHourOfDay;
        }

        public final Integer getStartMinuteOfHour() {
            return this.startMinuteOfHour;
        }

        @Override
        public final Builder startMinuteOfHour(Integer startMinuteOfHour) {
            this.startMinuteOfHour = startMinuteOfHour;
            return this;
        }

        public final void setStartMinuteOfHour(Integer startMinuteOfHour) {
            this.startMinuteOfHour = startMinuteOfHour;
        }

        public final Integer getEndHourOfDay() {
            return this.endHourOfDay;
        }

        @Override
        public final Builder endHourOfDay(Integer endHourOfDay) {
            this.endHourOfDay = endHourOfDay;
            return this;
        }

        public final void setEndHourOfDay(Integer endHourOfDay) {
            this.endHourOfDay = endHourOfDay;
        }

        public final Integer getEndMinuteOfHour() {
            return this.endMinuteOfHour;
        }

        @Override
        public final Builder endMinuteOfHour(Integer endMinuteOfHour) {
            this.endMinuteOfHour = endMinuteOfHour;
            return this;
        }

        public final void setEndMinuteOfHour(Integer endMinuteOfHour) {
            this.endMinuteOfHour = endMinuteOfHour;
        }

        public final Collection<Integer> getDaysOfWeek() {
            if (this.daysOfWeek instanceof SdkAutoConstructList) {
                return null;
            }
            return this.daysOfWeek;
        }

        @Override
        public final Builder daysOfWeek(Collection<Integer> daysOfWeek) {
            this.daysOfWeek = DaysOfWeekCopier.copy(daysOfWeek);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder daysOfWeek(Integer ... daysOfWeek) {
            this.daysOfWeek(Arrays.asList(daysOfWeek));
            return this;
        }

        public final void setDaysOfWeek(Collection<Integer> daysOfWeek) {
            this.daysOfWeek = DaysOfWeekCopier.copy(daysOfWeek);
        }

        public final Long getAverageUploadRateLimitInBitsPerSec() {
            return this.averageUploadRateLimitInBitsPerSec;
        }

        @Override
        public final Builder averageUploadRateLimitInBitsPerSec(Long averageUploadRateLimitInBitsPerSec) {
            this.averageUploadRateLimitInBitsPerSec = averageUploadRateLimitInBitsPerSec;
            return this;
        }

        public final void setAverageUploadRateLimitInBitsPerSec(Long averageUploadRateLimitInBitsPerSec) {
            this.averageUploadRateLimitInBitsPerSec = averageUploadRateLimitInBitsPerSec;
        }

        public final Long getAverageDownloadRateLimitInBitsPerSec() {
            return this.averageDownloadRateLimitInBitsPerSec;
        }

        @Override
        public final Builder averageDownloadRateLimitInBitsPerSec(Long averageDownloadRateLimitInBitsPerSec) {
            this.averageDownloadRateLimitInBitsPerSec = averageDownloadRateLimitInBitsPerSec;
            return this;
        }

        public final void setAverageDownloadRateLimitInBitsPerSec(Long averageDownloadRateLimitInBitsPerSec) {
            this.averageDownloadRateLimitInBitsPerSec = averageDownloadRateLimitInBitsPerSec;
        }

        public BandwidthRateLimitInterval build() {
            return new BandwidthRateLimitInterval(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BandwidthRateLimitInterval> {
        public Builder startHourOfDay(Integer var1);

        public Builder startMinuteOfHour(Integer var1);

        public Builder endHourOfDay(Integer var1);

        public Builder endMinuteOfHour(Integer var1);

        public Builder daysOfWeek(Collection<Integer> var1);

        public Builder daysOfWeek(Integer ... var1);

        public Builder averageUploadRateLimitInBitsPerSec(Long var1);

        public Builder averageDownloadRateLimitInBitsPerSec(Long var1);
    }
}

