/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.OpsItemDataValue;
import software.amazon.awssdk.services.ssm.model.OpsItemNotification;
import software.amazon.awssdk.services.ssm.model.OpsItemNotificationsCopier;
import software.amazon.awssdk.services.ssm.model.OpsItemOperationalDataCopier;
import software.amazon.awssdk.services.ssm.model.OpsItemOpsDataKeysListCopier;
import software.amazon.awssdk.services.ssm.model.OpsItemStatus;
import software.amazon.awssdk.services.ssm.model.RelatedOpsItem;
import software.amazon.awssdk.services.ssm.model.RelatedOpsItemsCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateOpsItemRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, UpdateOpsItemRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateOpsItemRequest.getter(UpdateOpsItemRequest::description)).setter(UpdateOpsItemRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, OpsItemDataValue>> OPERATIONAL_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OperationalData").getter(UpdateOpsItemRequest.getter(UpdateOpsItemRequest::operationalData)).setter(UpdateOpsItemRequest.setter(Builder::operationalData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationalData").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpsItemDataValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OPERATIONAL_DATA_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OperationalDataToDelete").getter(UpdateOpsItemRequest.getter(UpdateOpsItemRequest::operationalDataToDelete)).setter(UpdateOpsItemRequest.setter(Builder::operationalDataToDelete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationalDataToDelete").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OpsItemNotification>> NOTIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Notifications").getter(UpdateOpsItemRequest.getter(UpdateOpsItemRequest::notifications)).setter(UpdateOpsItemRequest.setter(Builder::notifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpsItemNotification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(UpdateOpsItemRequest.getter(UpdateOpsItemRequest::priority)).setter(UpdateOpsItemRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<List<RelatedOpsItem>> RELATED_OPS_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RelatedOpsItems").getter(UpdateOpsItemRequest.getter(UpdateOpsItemRequest::relatedOpsItems)).setter(UpdateOpsItemRequest.setter(Builder::relatedOpsItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedOpsItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelatedOpsItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(UpdateOpsItemRequest.getter(UpdateOpsItemRequest::statusAsString)).setter(UpdateOpsItemRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> OPS_ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpsItemId").getter(UpdateOpsItemRequest.getter(UpdateOpsItemRequest::opsItemId)).setter(UpdateOpsItemRequest.setter(Builder::opsItemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(UpdateOpsItemRequest.getter(UpdateOpsItemRequest::title)).setter(UpdateOpsItemRequest.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(UpdateOpsItemRequest.getter(UpdateOpsItemRequest::category)).setter(UpdateOpsItemRequest.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(UpdateOpsItemRequest.getter(UpdateOpsItemRequest::severity)).setter(UpdateOpsItemRequest.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<Instant> ACTUAL_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ActualStartTime").getter(UpdateOpsItemRequest.getter(UpdateOpsItemRequest::actualStartTime)).setter(UpdateOpsItemRequest.setter(Builder::actualStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualStartTime").build()}).build();
    private static final SdkField<Instant> ACTUAL_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ActualEndTime").getter(UpdateOpsItemRequest.getter(UpdateOpsItemRequest::actualEndTime)).setter(UpdateOpsItemRequest.setter(Builder::actualEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualEndTime").build()}).build();
    private static final SdkField<Instant> PLANNED_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PlannedStartTime").getter(UpdateOpsItemRequest.getter(UpdateOpsItemRequest::plannedStartTime)).setter(UpdateOpsItemRequest.setter(Builder::plannedStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlannedStartTime").build()}).build();
    private static final SdkField<Instant> PLANNED_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PlannedEndTime").getter(UpdateOpsItemRequest.getter(UpdateOpsItemRequest::plannedEndTime)).setter(UpdateOpsItemRequest.setter(Builder::plannedEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlannedEndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, OPERATIONAL_DATA_FIELD, OPERATIONAL_DATA_TO_DELETE_FIELD, NOTIFICATIONS_FIELD, PRIORITY_FIELD, RELATED_OPS_ITEMS_FIELD, STATUS_FIELD, OPS_ITEM_ID_FIELD, TITLE_FIELD, CATEGORY_FIELD, SEVERITY_FIELD, ACTUAL_START_TIME_FIELD, ACTUAL_END_TIME_FIELD, PLANNED_START_TIME_FIELD, PLANNED_END_TIME_FIELD));
    private final String description;
    private final Map<String, OpsItemDataValue> operationalData;
    private final List<String> operationalDataToDelete;
    private final List<OpsItemNotification> notifications;
    private final Integer priority;
    private final List<RelatedOpsItem> relatedOpsItems;
    private final String status;
    private final String opsItemId;
    private final String title;
    private final String category;
    private final String severity;
    private final Instant actualStartTime;
    private final Instant actualEndTime;
    private final Instant plannedStartTime;
    private final Instant plannedEndTime;

    private UpdateOpsItemRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.operationalData = builder.operationalData;
        this.operationalDataToDelete = builder.operationalDataToDelete;
        this.notifications = builder.notifications;
        this.priority = builder.priority;
        this.relatedOpsItems = builder.relatedOpsItems;
        this.status = builder.status;
        this.opsItemId = builder.opsItemId;
        this.title = builder.title;
        this.category = builder.category;
        this.severity = builder.severity;
        this.actualStartTime = builder.actualStartTime;
        this.actualEndTime = builder.actualEndTime;
        this.plannedStartTime = builder.plannedStartTime;
        this.plannedEndTime = builder.plannedEndTime;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasOperationalData() {
        return this.operationalData != null && !(this.operationalData instanceof SdkAutoConstructMap);
    }

    public final Map<String, OpsItemDataValue> operationalData() {
        return this.operationalData;
    }

    public final boolean hasOperationalDataToDelete() {
        return this.operationalDataToDelete != null && !(this.operationalDataToDelete instanceof SdkAutoConstructList);
    }

    public final List<String> operationalDataToDelete() {
        return this.operationalDataToDelete;
    }

    public final boolean hasNotifications() {
        return this.notifications != null && !(this.notifications instanceof SdkAutoConstructList);
    }

    public final List<OpsItemNotification> notifications() {
        return this.notifications;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final boolean hasRelatedOpsItems() {
        return this.relatedOpsItems != null && !(this.relatedOpsItems instanceof SdkAutoConstructList);
    }

    public final List<RelatedOpsItem> relatedOpsItems() {
        return this.relatedOpsItems;
    }

    public final OpsItemStatus status() {
        return OpsItemStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String opsItemId() {
        return this.opsItemId;
    }

    public final String title() {
        return this.title;
    }

    public final String category() {
        return this.category;
    }

    public final String severity() {
        return this.severity;
    }

    public final Instant actualStartTime() {
        return this.actualStartTime;
    }

    public final Instant actualEndTime() {
        return this.actualEndTime;
    }

    public final Instant plannedStartTime() {
        return this.plannedStartTime;
    }

    public final Instant plannedEndTime() {
        return this.plannedEndTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperationalData() ? this.operationalData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperationalDataToDelete() ? this.operationalDataToDelete() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotifications() ? this.notifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedOpsItems() ? this.relatedOpsItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.opsItemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.plannedStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.plannedEndTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOpsItemRequest)) {
            return false;
        }
        UpdateOpsItemRequest other = (UpdateOpsItemRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && this.hasOperationalData() == other.hasOperationalData() && Objects.equals(this.operationalData(), other.operationalData()) && this.hasOperationalDataToDelete() == other.hasOperationalDataToDelete() && Objects.equals(this.operationalDataToDelete(), other.operationalDataToDelete()) && this.hasNotifications() == other.hasNotifications() && Objects.equals(this.notifications(), other.notifications()) && Objects.equals(this.priority(), other.priority()) && this.hasRelatedOpsItems() == other.hasRelatedOpsItems() && Objects.equals(this.relatedOpsItems(), other.relatedOpsItems()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.opsItemId(), other.opsItemId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.category(), other.category()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.actualStartTime(), other.actualStartTime()) && Objects.equals(this.actualEndTime(), other.actualEndTime()) && Objects.equals(this.plannedStartTime(), other.plannedStartTime()) && Objects.equals(this.plannedEndTime(), other.plannedEndTime());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateOpsItemRequest").add("Description", (Object)this.description()).add("OperationalData", this.hasOperationalData() ? this.operationalData() : null).add("OperationalDataToDelete", this.hasOperationalDataToDelete() ? this.operationalDataToDelete() : null).add("Notifications", this.hasNotifications() ? this.notifications() : null).add("Priority", (Object)this.priority()).add("RelatedOpsItems", this.hasRelatedOpsItems() ? this.relatedOpsItems() : null).add("Status", (Object)this.statusAsString()).add("OpsItemId", (Object)this.opsItemId()).add("Title", (Object)this.title()).add("Category", (Object)this.category()).add("Severity", (Object)this.severity()).add("ActualStartTime", (Object)this.actualStartTime()).add("ActualEndTime", (Object)this.actualEndTime()).add("PlannedStartTime", (Object)this.plannedStartTime()).add("PlannedEndTime", (Object)this.plannedEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "OperationalData": {
                return Optional.ofNullable(clazz.cast(this.operationalData()));
            }
            case "OperationalDataToDelete": {
                return Optional.ofNullable(clazz.cast(this.operationalDataToDelete()));
            }
            case "Notifications": {
                return Optional.ofNullable(clazz.cast(this.notifications()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "RelatedOpsItems": {
                return Optional.ofNullable(clazz.cast(this.relatedOpsItems()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "OpsItemId": {
                return Optional.ofNullable(clazz.cast(this.opsItemId()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "ActualStartTime": {
                return Optional.ofNullable(clazz.cast(this.actualStartTime()));
            }
            case "ActualEndTime": {
                return Optional.ofNullable(clazz.cast(this.actualEndTime()));
            }
            case "PlannedStartTime": {
                return Optional.ofNullable(clazz.cast(this.plannedStartTime()));
            }
            case "PlannedEndTime": {
                return Optional.ofNullable(clazz.cast(this.plannedEndTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateOpsItemRequest, T> g) {
        return obj -> g.apply((UpdateOpsItemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String description;
        private Map<String, OpsItemDataValue> operationalData = DefaultSdkAutoConstructMap.getInstance();
        private List<String> operationalDataToDelete = DefaultSdkAutoConstructList.getInstance();
        private List<OpsItemNotification> notifications = DefaultSdkAutoConstructList.getInstance();
        private Integer priority;
        private List<RelatedOpsItem> relatedOpsItems = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String opsItemId;
        private String title;
        private String category;
        private String severity;
        private Instant actualStartTime;
        private Instant actualEndTime;
        private Instant plannedStartTime;
        private Instant plannedEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOpsItemRequest model) {
            super(model);
            this.description(model.description);
            this.operationalData(model.operationalData);
            this.operationalDataToDelete(model.operationalDataToDelete);
            this.notifications(model.notifications);
            this.priority(model.priority);
            this.relatedOpsItems(model.relatedOpsItems);
            this.status(model.status);
            this.opsItemId(model.opsItemId);
            this.title(model.title);
            this.category(model.category);
            this.severity(model.severity);
            this.actualStartTime(model.actualStartTime);
            this.actualEndTime(model.actualEndTime);
            this.plannedStartTime(model.plannedStartTime);
            this.plannedEndTime(model.plannedEndTime);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Map<String, OpsItemDataValue.Builder> getOperationalData() {
            Map<String, OpsItemDataValue.Builder> result = OpsItemOperationalDataCopier.copyToBuilder(this.operationalData);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder operationalData(Map<String, OpsItemDataValue> operationalData) {
            this.operationalData = OpsItemOperationalDataCopier.copy(operationalData);
            return this;
        }

        public final void setOperationalData(Map<String, OpsItemDataValue.BuilderImpl> operationalData) {
            this.operationalData = OpsItemOperationalDataCopier.copyFromBuilder(operationalData);
        }

        public final Collection<String> getOperationalDataToDelete() {
            if (this.operationalDataToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return this.operationalDataToDelete;
        }

        @Override
        public final Builder operationalDataToDelete(Collection<String> operationalDataToDelete) {
            this.operationalDataToDelete = OpsItemOpsDataKeysListCopier.copy(operationalDataToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationalDataToDelete(String ... operationalDataToDelete) {
            this.operationalDataToDelete(Arrays.asList(operationalDataToDelete));
            return this;
        }

        public final void setOperationalDataToDelete(Collection<String> operationalDataToDelete) {
            this.operationalDataToDelete = OpsItemOpsDataKeysListCopier.copy(operationalDataToDelete);
        }

        public final List<OpsItemNotification.Builder> getNotifications() {
            List<OpsItemNotification.Builder> result = OpsItemNotificationsCopier.copyToBuilder(this.notifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder notifications(Collection<OpsItemNotification> notifications) {
            this.notifications = OpsItemNotificationsCopier.copy(notifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifications(OpsItemNotification ... notifications) {
            this.notifications(Arrays.asList(notifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifications(Consumer<OpsItemNotification.Builder> ... notifications) {
            this.notifications(Stream.of(notifications).map(c -> (OpsItemNotification)((OpsItemNotification.Builder)OpsItemNotification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNotifications(Collection<OpsItemNotification.BuilderImpl> notifications) {
            this.notifications = OpsItemNotificationsCopier.copyFromBuilder(notifications);
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final List<RelatedOpsItem.Builder> getRelatedOpsItems() {
            List<RelatedOpsItem.Builder> result = RelatedOpsItemsCopier.copyToBuilder(this.relatedOpsItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder relatedOpsItems(Collection<RelatedOpsItem> relatedOpsItems) {
            this.relatedOpsItems = RelatedOpsItemsCopier.copy(relatedOpsItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedOpsItems(RelatedOpsItem ... relatedOpsItems) {
            this.relatedOpsItems(Arrays.asList(relatedOpsItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedOpsItems(Consumer<RelatedOpsItem.Builder> ... relatedOpsItems) {
            this.relatedOpsItems(Stream.of(relatedOpsItems).map(c -> (RelatedOpsItem)((RelatedOpsItem.Builder)RelatedOpsItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRelatedOpsItems(Collection<RelatedOpsItem.BuilderImpl> relatedOpsItems) {
            this.relatedOpsItems = RelatedOpsItemsCopier.copyFromBuilder(relatedOpsItems);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OpsItemStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getOpsItemId() {
            return this.opsItemId;
        }

        @Override
        public final Builder opsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
            return this;
        }

        public final void setOpsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final Instant getActualStartTime() {
            return this.actualStartTime;
        }

        @Override
        public final Builder actualStartTime(Instant actualStartTime) {
            this.actualStartTime = actualStartTime;
            return this;
        }

        public final void setActualStartTime(Instant actualStartTime) {
            this.actualStartTime = actualStartTime;
        }

        public final Instant getActualEndTime() {
            return this.actualEndTime;
        }

        @Override
        public final Builder actualEndTime(Instant actualEndTime) {
            this.actualEndTime = actualEndTime;
            return this;
        }

        public final void setActualEndTime(Instant actualEndTime) {
            this.actualEndTime = actualEndTime;
        }

        public final Instant getPlannedStartTime() {
            return this.plannedStartTime;
        }

        @Override
        public final Builder plannedStartTime(Instant plannedStartTime) {
            this.plannedStartTime = plannedStartTime;
            return this;
        }

        public final void setPlannedStartTime(Instant plannedStartTime) {
            this.plannedStartTime = plannedStartTime;
        }

        public final Instant getPlannedEndTime() {
            return this.plannedEndTime;
        }

        @Override
        public final Builder plannedEndTime(Instant plannedEndTime) {
            this.plannedEndTime = plannedEndTime;
            return this;
        }

        public final void setPlannedEndTime(Instant plannedEndTime) {
            this.plannedEndTime = plannedEndTime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOpsItemRequest build() {
            return new UpdateOpsItemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateOpsItemRequest> {
        public Builder description(String var1);

        public Builder operationalData(Map<String, OpsItemDataValue> var1);

        public Builder operationalDataToDelete(Collection<String> var1);

        public Builder operationalDataToDelete(String ... var1);

        public Builder notifications(Collection<OpsItemNotification> var1);

        public Builder notifications(OpsItemNotification ... var1);

        public Builder notifications(Consumer<OpsItemNotification.Builder> ... var1);

        public Builder priority(Integer var1);

        public Builder relatedOpsItems(Collection<RelatedOpsItem> var1);

        public Builder relatedOpsItems(RelatedOpsItem ... var1);

        public Builder relatedOpsItems(Consumer<RelatedOpsItem.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(OpsItemStatus var1);

        public Builder opsItemId(String var1);

        public Builder title(String var1);

        public Builder category(String var1);

        public Builder severity(String var1);

        public Builder actualStartTime(Instant var1);

        public Builder actualEndTime(Instant var1);

        public Builder plannedStartTime(Instant var1);

        public Builder plannedEndTime(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

