/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sms.model.AppValidationStrategy;
import software.amazon.awssdk.services.sms.model.SSMValidationParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppValidationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppValidationConfiguration> {
    private static final SdkField<String> VALIDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("validationId").getter(AppValidationConfiguration.getter(AppValidationConfiguration::validationId)).setter(AppValidationConfiguration.setter(Builder::validationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AppValidationConfiguration.getter(AppValidationConfiguration::name)).setter(AppValidationConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> APP_VALIDATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appValidationStrategy").getter(AppValidationConfiguration.getter(AppValidationConfiguration::appValidationStrategyAsString)).setter(AppValidationConfiguration.setter(Builder::appValidationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appValidationStrategy").build()}).build();
    private static final SdkField<SSMValidationParameters> SSM_VALIDATION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ssmValidationParameters").getter(AppValidationConfiguration.getter(AppValidationConfiguration::ssmValidationParameters)).setter(AppValidationConfiguration.setter(Builder::ssmValidationParameters)).constructor(SSMValidationParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmValidationParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_ID_FIELD, NAME_FIELD, APP_VALIDATION_STRATEGY_FIELD, SSM_VALIDATION_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String validationId;
    private final String name;
    private final String appValidationStrategy;
    private final SSMValidationParameters ssmValidationParameters;

    private AppValidationConfiguration(BuilderImpl builder) {
        this.validationId = builder.validationId;
        this.name = builder.name;
        this.appValidationStrategy = builder.appValidationStrategy;
        this.ssmValidationParameters = builder.ssmValidationParameters;
    }

    public final String validationId() {
        return this.validationId;
    }

    public final String name() {
        return this.name;
    }

    public final AppValidationStrategy appValidationStrategy() {
        return AppValidationStrategy.fromValue(this.appValidationStrategy);
    }

    public final String appValidationStrategyAsString() {
        return this.appValidationStrategy;
    }

    public final SSMValidationParameters ssmValidationParameters() {
        return this.ssmValidationParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.validationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.appValidationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssmValidationParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppValidationConfiguration)) {
            return false;
        }
        AppValidationConfiguration other = (AppValidationConfiguration)obj;
        return Objects.equals(this.validationId(), other.validationId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.appValidationStrategyAsString(), other.appValidationStrategyAsString()) && Objects.equals(this.ssmValidationParameters(), other.ssmValidationParameters());
    }

    public final String toString() {
        return ToString.builder((String)"AppValidationConfiguration").add("ValidationId", (Object)this.validationId()).add("Name", (Object)this.name()).add("AppValidationStrategy", (Object)this.appValidationStrategyAsString()).add("SsmValidationParameters", (Object)this.ssmValidationParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "validationId": {
                return Optional.ofNullable(clazz.cast(this.validationId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "appValidationStrategy": {
                return Optional.ofNullable(clazz.cast(this.appValidationStrategyAsString()));
            }
            case "ssmValidationParameters": {
                return Optional.ofNullable(clazz.cast(this.ssmValidationParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppValidationConfiguration, T> g) {
        return obj -> g.apply((AppValidationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String validationId;
        private String name;
        private String appValidationStrategy;
        private SSMValidationParameters ssmValidationParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(AppValidationConfiguration model) {
            this.validationId(model.validationId);
            this.name(model.name);
            this.appValidationStrategy(model.appValidationStrategy);
            this.ssmValidationParameters(model.ssmValidationParameters);
        }

        public final String getValidationId() {
            return this.validationId;
        }

        @Override
        public final Builder validationId(String validationId) {
            this.validationId = validationId;
            return this;
        }

        public final void setValidationId(String validationId) {
            this.validationId = validationId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getAppValidationStrategy() {
            return this.appValidationStrategy;
        }

        @Override
        public final Builder appValidationStrategy(String appValidationStrategy) {
            this.appValidationStrategy = appValidationStrategy;
            return this;
        }

        @Override
        public final Builder appValidationStrategy(AppValidationStrategy appValidationStrategy) {
            this.appValidationStrategy(appValidationStrategy == null ? null : appValidationStrategy.toString());
            return this;
        }

        public final void setAppValidationStrategy(String appValidationStrategy) {
            this.appValidationStrategy = appValidationStrategy;
        }

        public final SSMValidationParameters.Builder getSsmValidationParameters() {
            return this.ssmValidationParameters != null ? this.ssmValidationParameters.toBuilder() : null;
        }

        @Override
        public final Builder ssmValidationParameters(SSMValidationParameters ssmValidationParameters) {
            this.ssmValidationParameters = ssmValidationParameters;
            return this;
        }

        public final void setSsmValidationParameters(SSMValidationParameters.BuilderImpl ssmValidationParameters) {
            this.ssmValidationParameters = ssmValidationParameters != null ? ssmValidationParameters.build() : null;
        }

        public AppValidationConfiguration build() {
            return new AppValidationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppValidationConfiguration> {
        public Builder validationId(String var1);

        public Builder name(String var1);

        public Builder appValidationStrategy(String var1);

        public Builder appValidationStrategy(AppValidationStrategy var1);

        public Builder ssmValidationParameters(SSMValidationParameters var1);

        default public Builder ssmValidationParameters(Consumer<SSMValidationParameters.Builder> ssmValidationParameters) {
            return this.ssmValidationParameters((SSMValidationParameters)((SSMValidationParameters.Builder)SSMValidationParameters.builder().applyMutation(ssmValidationParameters)).build());
        }
    }
}

