/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Category {
    AWS_IOT("AWSIoT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Category(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Category fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Category.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Category> knownValues() {
        return Stream.of(Category.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

