/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2AsyncClient;
import software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest;
import software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsResponse;

public class ListSuppressedDestinationsPublisher
implements SdkPublisher<ListSuppressedDestinationsResponse> {
    private final SesV2AsyncClient client;
    private final ListSuppressedDestinationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSuppressedDestinationsPublisher(SesV2AsyncClient client, ListSuppressedDestinationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSuppressedDestinationsPublisher(SesV2AsyncClient client, ListSuppressedDestinationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSuppressedDestinationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSuppressedDestinationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSuppressedDestinationsResponseFetcher
    implements AsyncPageFetcher<ListSuppressedDestinationsResponse> {
        private ListSuppressedDestinationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSuppressedDestinationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSuppressedDestinationsResponse> nextPage(ListSuppressedDestinationsResponse previousPage) {
            if (previousPage == null) {
                return ListSuppressedDestinationsPublisher.this.client.listSuppressedDestinations(ListSuppressedDestinationsPublisher.this.firstRequest);
            }
            return ListSuppressedDestinationsPublisher.this.client.listSuppressedDestinations((ListSuppressedDestinationsRequest)((Object)ListSuppressedDestinationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

