/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.ImportJobSummary;
import software.amazon.awssdk.services.sesv2.model.ImportJobSummaryListCopier;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListImportJobsResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, ListImportJobsResponse> {
    private static final SdkField<List<ImportJobSummary>> IMPORT_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImportJobs").getter(ListImportJobsResponse.getter(ListImportJobsResponse::importJobs)).setter(ListImportJobsResponse.setter(Builder::importJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImportJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListImportJobsResponse.getter(ListImportJobsResponse::nextToken)).setter(ListImportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_JOBS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ImportJobSummary> importJobs;
    private final String nextToken;

    private ListImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.importJobs = builder.importJobs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasImportJobs() {
        return this.importJobs != null && !(this.importJobs instanceof SdkAutoConstructList);
    }

    public final List<ImportJobSummary> importJobs() {
        return this.importJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImportJobs() ? this.importJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImportJobsResponse)) {
            return false;
        }
        ListImportJobsResponse other = (ListImportJobsResponse)((Object)obj);
        return this.hasImportJobs() == other.hasImportJobs() && Objects.equals(this.importJobs(), other.importJobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListImportJobsResponse").add("ImportJobs", this.hasImportJobs() ? this.importJobs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImportJobs": {
                return Optional.ofNullable(clazz.cast(this.importJobs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListImportJobsResponse, T> g) {
        return obj -> g.apply((ListImportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private List<ImportJobSummary> importJobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImportJobsResponse model) {
            super(model);
            this.importJobs(model.importJobs);
            this.nextToken(model.nextToken);
        }

        public final List<ImportJobSummary.Builder> getImportJobs() {
            List<ImportJobSummary.Builder> result = ImportJobSummaryListCopier.copyToBuilder(this.importJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder importJobs(Collection<ImportJobSummary> importJobs) {
            this.importJobs = ImportJobSummaryListCopier.copy(importJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importJobs(ImportJobSummary ... importJobs) {
            this.importJobs(Arrays.asList(importJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importJobs(Consumer<ImportJobSummary.Builder> ... importJobs) {
            this.importJobs(Stream.of(importJobs).map(c -> (ImportJobSummary)((ImportJobSummary.Builder)ImportJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setImportJobs(Collection<ImportJobSummary.BuilderImpl> importJobs) {
            this.importJobs = ImportJobSummaryListCopier.copyFromBuilder(importJobs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListImportJobsResponse build() {
            return new ListImportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListImportJobsResponse> {
        public Builder importJobs(Collection<ImportJobSummary> var1);

        public Builder importJobs(ImportJobSummary ... var1);

        public Builder importJobs(Consumer<ImportJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

