/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BulkEmailStatus {
    SUCCESS("Success"),
    MESSAGE_REJECTED("MessageRejected"),
    MAIL_FROM_DOMAIN_NOT_VERIFIED("MailFromDomainNotVerified"),
    CONFIGURATION_SET_DOES_NOT_EXIST("ConfigurationSetDoesNotExist"),
    TEMPLATE_DOES_NOT_EXIST("TemplateDoesNotExist"),
    ACCOUNT_SUSPENDED("AccountSuspended"),
    ACCOUNT_THROTTLED("AccountThrottled"),
    ACCOUNT_DAILY_QUOTA_EXCEEDED("AccountDailyQuotaExceeded"),
    INVALID_SENDING_POOL_NAME("InvalidSendingPoolName"),
    ACCOUNT_SENDING_PAUSED("AccountSendingPaused"),
    CONFIGURATION_SET_SENDING_PAUSED("ConfigurationSetSendingPaused"),
    INVALID_PARAMETER_VALUE("InvalidParameterValue"),
    TRANSIENT_FAILURE("TransientFailure"),
    FAILED("Failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BulkEmailStatus> VALUE_MAP;
    private final String value;

    private BulkEmailStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BulkEmailStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BulkEmailStatus> knownValues() {
        EnumSet<BulkEmailStatus> knownValues = EnumSet.allOf(BulkEmailStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BulkEmailStatus.class, BulkEmailStatus::toString);
    }
}

