/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RoutingPolicy {
    MULTIVALUE("MULTIVALUE"),
    WEIGHTED("WEIGHTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RoutingPolicy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RoutingPolicy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RoutingPolicy.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RoutingPolicy> knownValues() {
        return Stream.of(RoutingPolicy.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

