/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery;

import java.util.function.Consumer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.servicediscovery.DefaultServiceDiscoveryClientBuilder;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryClientBuilder;
import software.amazon.awssdk.services.servicediscovery.model.CreateHttpNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreateHttpNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.CreatePrivateDnsNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreatePrivateDnsNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.CreateServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreateServiceResponse;
import software.amazon.awssdk.services.servicediscovery.model.CustomHealthNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DeleteServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.DeleteServiceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceRequest;
import software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DiscoverInstancesRequest;
import software.amazon.awssdk.services.servicediscovery.model.DiscoverInstancesResponse;
import software.amazon.awssdk.services.servicediscovery.model.DuplicateRequestException;
import software.amazon.awssdk.services.servicediscovery.model.GetInstanceRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetInstanceResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetOperationRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetOperationResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetServiceResponse;
import software.amazon.awssdk.services.servicediscovery.model.InstanceNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.InvalidInputException;
import software.amazon.awssdk.services.servicediscovery.model.ListInstancesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListInstancesResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListNamespacesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListNamespacesResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListOperationsRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListOperationsResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListServicesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListServicesResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.servicediscovery.model.NamespaceAlreadyExistsException;
import software.amazon.awssdk.services.servicediscovery.model.NamespaceNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.OperationNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.RegisterInstanceRequest;
import software.amazon.awssdk.services.servicediscovery.model.RegisterInstanceResponse;
import software.amazon.awssdk.services.servicediscovery.model.RequestLimitExceededException;
import software.amazon.awssdk.services.servicediscovery.model.ResourceInUseException;
import software.amazon.awssdk.services.servicediscovery.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.servicediscovery.model.ResourceNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.ServiceAlreadyExistsException;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryException;
import software.amazon.awssdk.services.servicediscovery.model.ServiceNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.TagResourceRequest;
import software.amazon.awssdk.services.servicediscovery.model.TagResourceResponse;
import software.amazon.awssdk.services.servicediscovery.model.TooManyTagsException;
import software.amazon.awssdk.services.servicediscovery.model.UntagResourceRequest;
import software.amazon.awssdk.services.servicediscovery.model.UntagResourceResponse;
import software.amazon.awssdk.services.servicediscovery.model.UpdateInstanceCustomHealthStatusRequest;
import software.amazon.awssdk.services.servicediscovery.model.UpdateInstanceCustomHealthStatusResponse;
import software.amazon.awssdk.services.servicediscovery.model.UpdateServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.UpdateServiceResponse;
import software.amazon.awssdk.services.servicediscovery.paginators.GetInstancesHealthStatusIterable;
import software.amazon.awssdk.services.servicediscovery.paginators.ListInstancesIterable;
import software.amazon.awssdk.services.servicediscovery.paginators.ListNamespacesIterable;
import software.amazon.awssdk.services.servicediscovery.paginators.ListOperationsIterable;
import software.amazon.awssdk.services.servicediscovery.paginators.ListServicesIterable;

public interface ServiceDiscoveryClient
extends SdkClient {
    public static final String SERVICE_NAME = "servicediscovery";
    public static final String SERVICE_METADATA_ID = "servicediscovery";

    public static ServiceDiscoveryClient create() {
        return (ServiceDiscoveryClient)ServiceDiscoveryClient.builder().build();
    }

    public static ServiceDiscoveryClientBuilder builder() {
        return new DefaultServiceDiscoveryClientBuilder();
    }

    default public CreateHttpNamespaceResponse createHttpNamespace(CreateHttpNamespaceRequest createHttpNamespaceRequest) throws InvalidInputException, NamespaceAlreadyExistsException, ResourceLimitExceededException, DuplicateRequestException, TooManyTagsException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public CreateHttpNamespaceResponse createHttpNamespace(Consumer<CreateHttpNamespaceRequest.Builder> createHttpNamespaceRequest) throws InvalidInputException, NamespaceAlreadyExistsException, ResourceLimitExceededException, DuplicateRequestException, TooManyTagsException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.createHttpNamespace((CreateHttpNamespaceRequest)((Object)((CreateHttpNamespaceRequest.Builder)CreateHttpNamespaceRequest.builder().applyMutation(createHttpNamespaceRequest)).build()));
    }

    default public CreatePrivateDnsNamespaceResponse createPrivateDnsNamespace(CreatePrivateDnsNamespaceRequest createPrivateDnsNamespaceRequest) throws InvalidInputException, NamespaceAlreadyExistsException, ResourceLimitExceededException, DuplicateRequestException, TooManyTagsException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public CreatePrivateDnsNamespaceResponse createPrivateDnsNamespace(Consumer<CreatePrivateDnsNamespaceRequest.Builder> createPrivateDnsNamespaceRequest) throws InvalidInputException, NamespaceAlreadyExistsException, ResourceLimitExceededException, DuplicateRequestException, TooManyTagsException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.createPrivateDnsNamespace((CreatePrivateDnsNamespaceRequest)((Object)((CreatePrivateDnsNamespaceRequest.Builder)CreatePrivateDnsNamespaceRequest.builder().applyMutation(createPrivateDnsNamespaceRequest)).build()));
    }

    default public CreatePublicDnsNamespaceResponse createPublicDnsNamespace(CreatePublicDnsNamespaceRequest createPublicDnsNamespaceRequest) throws InvalidInputException, NamespaceAlreadyExistsException, ResourceLimitExceededException, DuplicateRequestException, TooManyTagsException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public CreatePublicDnsNamespaceResponse createPublicDnsNamespace(Consumer<CreatePublicDnsNamespaceRequest.Builder> createPublicDnsNamespaceRequest) throws InvalidInputException, NamespaceAlreadyExistsException, ResourceLimitExceededException, DuplicateRequestException, TooManyTagsException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.createPublicDnsNamespace((CreatePublicDnsNamespaceRequest)((Object)((CreatePublicDnsNamespaceRequest.Builder)CreatePublicDnsNamespaceRequest.builder().applyMutation(createPublicDnsNamespaceRequest)).build()));
    }

    default public CreateServiceResponse createService(CreateServiceRequest createServiceRequest) throws InvalidInputException, ResourceLimitExceededException, NamespaceNotFoundException, ServiceAlreadyExistsException, TooManyTagsException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public CreateServiceResponse createService(Consumer<CreateServiceRequest.Builder> createServiceRequest) throws InvalidInputException, ResourceLimitExceededException, NamespaceNotFoundException, ServiceAlreadyExistsException, TooManyTagsException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.createService((CreateServiceRequest)((Object)((CreateServiceRequest.Builder)CreateServiceRequest.builder().applyMutation(createServiceRequest)).build()));
    }

    default public DeleteNamespaceResponse deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) throws InvalidInputException, NamespaceNotFoundException, ResourceInUseException, DuplicateRequestException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public DeleteNamespaceResponse deleteNamespace(Consumer<DeleteNamespaceRequest.Builder> deleteNamespaceRequest) throws InvalidInputException, NamespaceNotFoundException, ResourceInUseException, DuplicateRequestException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.deleteNamespace((DeleteNamespaceRequest)((Object)((DeleteNamespaceRequest.Builder)DeleteNamespaceRequest.builder().applyMutation(deleteNamespaceRequest)).build()));
    }

    default public DeleteServiceResponse deleteService(DeleteServiceRequest deleteServiceRequest) throws InvalidInputException, ServiceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public DeleteServiceResponse deleteService(Consumer<DeleteServiceRequest.Builder> deleteServiceRequest) throws InvalidInputException, ServiceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.deleteService((DeleteServiceRequest)((Object)((DeleteServiceRequest.Builder)DeleteServiceRequest.builder().applyMutation(deleteServiceRequest)).build()));
    }

    default public DeregisterInstanceResponse deregisterInstance(DeregisterInstanceRequest deregisterInstanceRequest) throws DuplicateRequestException, InvalidInputException, InstanceNotFoundException, ResourceInUseException, ServiceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public DeregisterInstanceResponse deregisterInstance(Consumer<DeregisterInstanceRequest.Builder> deregisterInstanceRequest) throws DuplicateRequestException, InvalidInputException, InstanceNotFoundException, ResourceInUseException, ServiceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.deregisterInstance((DeregisterInstanceRequest)((Object)((DeregisterInstanceRequest.Builder)DeregisterInstanceRequest.builder().applyMutation(deregisterInstanceRequest)).build()));
    }

    default public DiscoverInstancesResponse discoverInstances(DiscoverInstancesRequest discoverInstancesRequest) throws ServiceNotFoundException, NamespaceNotFoundException, InvalidInputException, RequestLimitExceededException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public DiscoverInstancesResponse discoverInstances(Consumer<DiscoverInstancesRequest.Builder> discoverInstancesRequest) throws ServiceNotFoundException, NamespaceNotFoundException, InvalidInputException, RequestLimitExceededException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.discoverInstances((DiscoverInstancesRequest)((Object)((DiscoverInstancesRequest.Builder)DiscoverInstancesRequest.builder().applyMutation(discoverInstancesRequest)).build()));
    }

    default public GetInstanceResponse getInstance(GetInstanceRequest getInstanceRequest) throws InstanceNotFoundException, InvalidInputException, ServiceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public GetInstanceResponse getInstance(Consumer<GetInstanceRequest.Builder> getInstanceRequest) throws InstanceNotFoundException, InvalidInputException, ServiceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.getInstance((GetInstanceRequest)((Object)((GetInstanceRequest.Builder)GetInstanceRequest.builder().applyMutation(getInstanceRequest)).build()));
    }

    default public GetInstancesHealthStatusResponse getInstancesHealthStatus(GetInstancesHealthStatusRequest getInstancesHealthStatusRequest) throws InstanceNotFoundException, InvalidInputException, ServiceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public GetInstancesHealthStatusResponse getInstancesHealthStatus(Consumer<GetInstancesHealthStatusRequest.Builder> getInstancesHealthStatusRequest) throws InstanceNotFoundException, InvalidInputException, ServiceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.getInstancesHealthStatus((GetInstancesHealthStatusRequest)((Object)((GetInstancesHealthStatusRequest.Builder)GetInstancesHealthStatusRequest.builder().applyMutation(getInstancesHealthStatusRequest)).build()));
    }

    default public GetInstancesHealthStatusIterable getInstancesHealthStatusPaginator(GetInstancesHealthStatusRequest getInstancesHealthStatusRequest) throws InstanceNotFoundException, InvalidInputException, ServiceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public GetInstancesHealthStatusIterable getInstancesHealthStatusPaginator(Consumer<GetInstancesHealthStatusRequest.Builder> getInstancesHealthStatusRequest) throws InstanceNotFoundException, InvalidInputException, ServiceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.getInstancesHealthStatusPaginator((GetInstancesHealthStatusRequest)((Object)((GetInstancesHealthStatusRequest.Builder)GetInstancesHealthStatusRequest.builder().applyMutation(getInstancesHealthStatusRequest)).build()));
    }

    default public GetNamespaceResponse getNamespace(GetNamespaceRequest getNamespaceRequest) throws InvalidInputException, NamespaceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public GetNamespaceResponse getNamespace(Consumer<GetNamespaceRequest.Builder> getNamespaceRequest) throws InvalidInputException, NamespaceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.getNamespace((GetNamespaceRequest)((Object)((GetNamespaceRequest.Builder)GetNamespaceRequest.builder().applyMutation(getNamespaceRequest)).build()));
    }

    default public GetOperationResponse getOperation(GetOperationRequest getOperationRequest) throws InvalidInputException, OperationNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public GetOperationResponse getOperation(Consumer<GetOperationRequest.Builder> getOperationRequest) throws InvalidInputException, OperationNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.getOperation((GetOperationRequest)((Object)((GetOperationRequest.Builder)GetOperationRequest.builder().applyMutation(getOperationRequest)).build()));
    }

    default public GetServiceResponse getService(GetServiceRequest getServiceRequest) throws InvalidInputException, ServiceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public GetServiceResponse getService(Consumer<GetServiceRequest.Builder> getServiceRequest) throws InvalidInputException, ServiceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.getService((GetServiceRequest)((Object)((GetServiceRequest.Builder)GetServiceRequest.builder().applyMutation(getServiceRequest)).build()));
    }

    default public ListInstancesResponse listInstances(ListInstancesRequest listInstancesRequest) throws ServiceNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public ListInstancesResponse listInstances(Consumer<ListInstancesRequest.Builder> listInstancesRequest) throws ServiceNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listInstances((ListInstancesRequest)((Object)((ListInstancesRequest.Builder)ListInstancesRequest.builder().applyMutation(listInstancesRequest)).build()));
    }

    default public ListInstancesIterable listInstancesPaginator(ListInstancesRequest listInstancesRequest) throws ServiceNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public ListInstancesIterable listInstancesPaginator(Consumer<ListInstancesRequest.Builder> listInstancesRequest) throws ServiceNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listInstancesPaginator((ListInstancesRequest)((Object)((ListInstancesRequest.Builder)ListInstancesRequest.builder().applyMutation(listInstancesRequest)).build()));
    }

    default public ListNamespacesResponse listNamespaces() throws InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listNamespaces((ListNamespacesRequest)((Object)ListNamespacesRequest.builder().build()));
    }

    default public ListNamespacesResponse listNamespaces(ListNamespacesRequest listNamespacesRequest) throws InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public ListNamespacesResponse listNamespaces(Consumer<ListNamespacesRequest.Builder> listNamespacesRequest) throws InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listNamespaces((ListNamespacesRequest)((Object)((ListNamespacesRequest.Builder)ListNamespacesRequest.builder().applyMutation(listNamespacesRequest)).build()));
    }

    default public ListNamespacesIterable listNamespacesPaginator() throws InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listNamespacesPaginator((ListNamespacesRequest)((Object)ListNamespacesRequest.builder().build()));
    }

    default public ListNamespacesIterable listNamespacesPaginator(ListNamespacesRequest listNamespacesRequest) throws InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public ListNamespacesIterable listNamespacesPaginator(Consumer<ListNamespacesRequest.Builder> listNamespacesRequest) throws InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listNamespacesPaginator((ListNamespacesRequest)((Object)((ListNamespacesRequest.Builder)ListNamespacesRequest.builder().applyMutation(listNamespacesRequest)).build()));
    }

    default public ListOperationsResponse listOperations() throws InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listOperations((ListOperationsRequest)((Object)ListOperationsRequest.builder().build()));
    }

    default public ListOperationsResponse listOperations(ListOperationsRequest listOperationsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public ListOperationsResponse listOperations(Consumer<ListOperationsRequest.Builder> listOperationsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listOperations((ListOperationsRequest)((Object)((ListOperationsRequest.Builder)ListOperationsRequest.builder().applyMutation(listOperationsRequest)).build()));
    }

    default public ListOperationsIterable listOperationsPaginator() throws InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listOperationsPaginator((ListOperationsRequest)((Object)ListOperationsRequest.builder().build()));
    }

    default public ListOperationsIterable listOperationsPaginator(ListOperationsRequest listOperationsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public ListOperationsIterable listOperationsPaginator(Consumer<ListOperationsRequest.Builder> listOperationsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listOperationsPaginator((ListOperationsRequest)((Object)((ListOperationsRequest.Builder)ListOperationsRequest.builder().applyMutation(listOperationsRequest)).build()));
    }

    default public ListServicesResponse listServices() throws InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listServices((ListServicesRequest)((Object)ListServicesRequest.builder().build()));
    }

    default public ListServicesResponse listServices(ListServicesRequest listServicesRequest) throws InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public ListServicesResponse listServices(Consumer<ListServicesRequest.Builder> listServicesRequest) throws InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listServices((ListServicesRequest)((Object)((ListServicesRequest.Builder)ListServicesRequest.builder().applyMutation(listServicesRequest)).build()));
    }

    default public ListServicesIterable listServicesPaginator() throws InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listServicesPaginator((ListServicesRequest)((Object)ListServicesRequest.builder().build()));
    }

    default public ListServicesIterable listServicesPaginator(ListServicesRequest listServicesRequest) throws InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public ListServicesIterable listServicesPaginator(Consumer<ListServicesRequest.Builder> listServicesRequest) throws InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listServicesPaginator((ListServicesRequest)((Object)((ListServicesRequest.Builder)ListServicesRequest.builder().applyMutation(listServicesRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public RegisterInstanceResponse registerInstance(RegisterInstanceRequest registerInstanceRequest) throws DuplicateRequestException, InvalidInputException, ResourceInUseException, ResourceLimitExceededException, ServiceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public RegisterInstanceResponse registerInstance(Consumer<RegisterInstanceRequest.Builder> registerInstanceRequest) throws DuplicateRequestException, InvalidInputException, ResourceInUseException, ResourceLimitExceededException, ServiceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.registerInstance((RegisterInstanceRequest)((Object)((RegisterInstanceRequest.Builder)RegisterInstanceRequest.builder().applyMutation(registerInstanceRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, TooManyTagsException, InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ResourceNotFoundException, TooManyTagsException, InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws ResourceNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateInstanceCustomHealthStatusResponse updateInstanceCustomHealthStatus(UpdateInstanceCustomHealthStatusRequest updateInstanceCustomHealthStatusRequest) throws InstanceNotFoundException, ServiceNotFoundException, CustomHealthNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public UpdateInstanceCustomHealthStatusResponse updateInstanceCustomHealthStatus(Consumer<UpdateInstanceCustomHealthStatusRequest.Builder> updateInstanceCustomHealthStatusRequest) throws InstanceNotFoundException, ServiceNotFoundException, CustomHealthNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.updateInstanceCustomHealthStatus((UpdateInstanceCustomHealthStatusRequest)((Object)((UpdateInstanceCustomHealthStatusRequest.Builder)UpdateInstanceCustomHealthStatusRequest.builder().applyMutation(updateInstanceCustomHealthStatusRequest)).build()));
    }

    default public UpdateServiceResponse updateService(UpdateServiceRequest updateServiceRequest) throws DuplicateRequestException, InvalidInputException, ServiceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public UpdateServiceResponse updateService(Consumer<UpdateServiceRequest.Builder> updateServiceRequest) throws DuplicateRequestException, InvalidInputException, ServiceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        return this.updateService((UpdateServiceRequest)((Object)((UpdateServiceRequest.Builder)UpdateServiceRequest.builder().applyMutation(updateServiceRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"servicediscovery");
    }
}

