/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TerminateProvisionedProductRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, TerminateProvisionedProductRequest> {
    private static final SdkField<String> PROVISIONED_PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisionedProductName").getter(TerminateProvisionedProductRequest.getter(TerminateProvisionedProductRequest::provisionedProductName)).setter(TerminateProvisionedProductRequest.setter(Builder::provisionedProductName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductName").build()}).build();
    private static final SdkField<String> PROVISIONED_PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisionedProductId").getter(TerminateProvisionedProductRequest.getter(TerminateProvisionedProductRequest::provisionedProductId)).setter(TerminateProvisionedProductRequest.setter(Builder::provisionedProductId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductId").build()}).build();
    private static final SdkField<String> TERMINATE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TerminateToken").getter(TerminateProvisionedProductRequest.getter(TerminateProvisionedProductRequest::terminateToken)).setter(TerminateProvisionedProductRequest.setter(Builder::terminateToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminateToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Boolean> IGNORE_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IgnoreErrors").getter(TerminateProvisionedProductRequest.getter(TerminateProvisionedProductRequest::ignoreErrors)).setter(TerminateProvisionedProductRequest.setter(Builder::ignoreErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IgnoreErrors").build()}).build();
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptLanguage").getter(TerminateProvisionedProductRequest.getter(TerminateProvisionedProductRequest::acceptLanguage)).setter(TerminateProvisionedProductRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<Boolean> RETAIN_PHYSICAL_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RetainPhysicalResources").getter(TerminateProvisionedProductRequest.getter(TerminateProvisionedProductRequest::retainPhysicalResources)).setter(TerminateProvisionedProductRequest.setter(Builder::retainPhysicalResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainPhysicalResources").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONED_PRODUCT_NAME_FIELD, PROVISIONED_PRODUCT_ID_FIELD, TERMINATE_TOKEN_FIELD, IGNORE_ERRORS_FIELD, ACCEPT_LANGUAGE_FIELD, RETAIN_PHYSICAL_RESOURCES_FIELD));
    private final String provisionedProductName;
    private final String provisionedProductId;
    private final String terminateToken;
    private final Boolean ignoreErrors;
    private final String acceptLanguage;
    private final Boolean retainPhysicalResources;

    private TerminateProvisionedProductRequest(BuilderImpl builder) {
        super(builder);
        this.provisionedProductName = builder.provisionedProductName;
        this.provisionedProductId = builder.provisionedProductId;
        this.terminateToken = builder.terminateToken;
        this.ignoreErrors = builder.ignoreErrors;
        this.acceptLanguage = builder.acceptLanguage;
        this.retainPhysicalResources = builder.retainPhysicalResources;
    }

    public final String provisionedProductName() {
        return this.provisionedProductName;
    }

    public final String provisionedProductId() {
        return this.provisionedProductId;
    }

    public final String terminateToken() {
        return this.terminateToken;
    }

    public final Boolean ignoreErrors() {
        return this.ignoreErrors;
    }

    public final String acceptLanguage() {
        return this.acceptLanguage;
    }

    public final Boolean retainPhysicalResources() {
        return this.retainPhysicalResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductName());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductId());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminateToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.ignoreErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.retainPhysicalResources());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateProvisionedProductRequest)) {
            return false;
        }
        TerminateProvisionedProductRequest other = (TerminateProvisionedProductRequest)((Object)obj);
        return Objects.equals(this.provisionedProductName(), other.provisionedProductName()) && Objects.equals(this.provisionedProductId(), other.provisionedProductId()) && Objects.equals(this.terminateToken(), other.terminateToken()) && Objects.equals(this.ignoreErrors(), other.ignoreErrors()) && Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.retainPhysicalResources(), other.retainPhysicalResources());
    }

    public final String toString() {
        return ToString.builder((String)"TerminateProvisionedProductRequest").add("ProvisionedProductName", (Object)this.provisionedProductName()).add("ProvisionedProductId", (Object)this.provisionedProductId()).add("TerminateToken", (Object)this.terminateToken()).add("IgnoreErrors", (Object)this.ignoreErrors()).add("AcceptLanguage", (Object)this.acceptLanguage()).add("RetainPhysicalResources", (Object)this.retainPhysicalResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisionedProductName": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductName()));
            }
            case "ProvisionedProductId": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductId()));
            }
            case "TerminateToken": {
                return Optional.ofNullable(clazz.cast(this.terminateToken()));
            }
            case "IgnoreErrors": {
                return Optional.ofNullable(clazz.cast(this.ignoreErrors()));
            }
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "RetainPhysicalResources": {
                return Optional.ofNullable(clazz.cast(this.retainPhysicalResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TerminateProvisionedProductRequest, T> g) {
        return obj -> g.apply((TerminateProvisionedProductRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String provisionedProductName;
        private String provisionedProductId;
        private String terminateToken;
        private Boolean ignoreErrors;
        private String acceptLanguage;
        private Boolean retainPhysicalResources;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateProvisionedProductRequest model) {
            super(model);
            this.provisionedProductName(model.provisionedProductName);
            this.provisionedProductId(model.provisionedProductId);
            this.terminateToken(model.terminateToken);
            this.ignoreErrors(model.ignoreErrors);
            this.acceptLanguage(model.acceptLanguage);
            this.retainPhysicalResources(model.retainPhysicalResources);
        }

        public final String getProvisionedProductName() {
            return this.provisionedProductName;
        }

        @Override
        public final Builder provisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
            return this;
        }

        public final void setProvisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
        }

        public final String getProvisionedProductId() {
            return this.provisionedProductId;
        }

        @Override
        public final Builder provisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
            return this;
        }

        public final void setProvisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
        }

        public final String getTerminateToken() {
            return this.terminateToken;
        }

        @Override
        public final Builder terminateToken(String terminateToken) {
            this.terminateToken = terminateToken;
            return this;
        }

        public final void setTerminateToken(String terminateToken) {
            this.terminateToken = terminateToken;
        }

        public final Boolean getIgnoreErrors() {
            return this.ignoreErrors;
        }

        @Override
        public final Builder ignoreErrors(Boolean ignoreErrors) {
            this.ignoreErrors = ignoreErrors;
            return this;
        }

        public final void setIgnoreErrors(Boolean ignoreErrors) {
            this.ignoreErrors = ignoreErrors;
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final Boolean getRetainPhysicalResources() {
            return this.retainPhysicalResources;
        }

        @Override
        public final Builder retainPhysicalResources(Boolean retainPhysicalResources) {
            this.retainPhysicalResources = retainPhysicalResources;
            return this;
        }

        public final void setRetainPhysicalResources(Boolean retainPhysicalResources) {
            this.retainPhysicalResources = retainPhysicalResources;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TerminateProvisionedProductRequest build() {
            return new TerminateProvisionedProductRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TerminateProvisionedProductRequest> {
        public Builder provisionedProductName(String var1);

        public Builder provisionedProductId(String var1);

        public Builder terminateToken(String var1);

        public Builder ignoreErrors(Boolean var1);

        public Builder acceptLanguage(String var1);

        public Builder retainPhysicalResources(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

