/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum NetworkDirection {
    IN("IN"),
    OUT("OUT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private NetworkDirection(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkDirection fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(NetworkDirection.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkDirection> knownValues() {
        return Stream.of(NetworkDirection.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

