/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsElasticsearchDomainEncryptionAtRestOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsElasticsearchDomainEncryptionAtRestOptions> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(AwsElasticsearchDomainEncryptionAtRestOptions.getter(AwsElasticsearchDomainEncryptionAtRestOptions::enabled)).setter(AwsElasticsearchDomainEncryptionAtRestOptions.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(AwsElasticsearchDomainEncryptionAtRestOptions.getter(AwsElasticsearchDomainEncryptionAtRestOptions::kmsKeyId)).setter(AwsElasticsearchDomainEncryptionAtRestOptions.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, KMS_KEY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final String kmsKeyId;

    private AwsElasticsearchDomainEncryptionAtRestOptions(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElasticsearchDomainEncryptionAtRestOptions)) {
            return false;
        }
        AwsElasticsearchDomainEncryptionAtRestOptions other = (AwsElasticsearchDomainEncryptionAtRestOptions)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"AwsElasticsearchDomainEncryptionAtRestOptions").add("Enabled", (Object)this.enabled()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsElasticsearchDomainEncryptionAtRestOptions, T> g) {
        return obj -> g.apply((AwsElasticsearchDomainEncryptionAtRestOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElasticsearchDomainEncryptionAtRestOptions model) {
            this.enabled(model.enabled);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public AwsElasticsearchDomainEncryptionAtRestOptions build() {
            return new AwsElasticsearchDomainEncryptionAtRestOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsElasticsearchDomainEncryptionAtRestOptions> {
        public Builder enabled(Boolean var1);

        public Builder kmsKeyId(String var1);
    }
}

