/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Type {
    OPEN_API3("OpenApi3"),
    JSON_SCHEMA_DRAFT4("JSONSchemaDraft4"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Type(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Type fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Type.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Type> knownValues() {
        return Stream.of(Type.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

