/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.savingsplans.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.savingsplans.model.SavingsplansRequest;
import software.amazon.awssdk.services.savingsplans.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSavingsPlanRequest
extends SavingsplansRequest
implements ToCopyableBuilder<Builder, CreateSavingsPlanRequest> {
    private static final SdkField<String> SAVINGS_PLAN_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("savingsPlanOfferingId").getter(CreateSavingsPlanRequest.getter(CreateSavingsPlanRequest::savingsPlanOfferingId)).setter(CreateSavingsPlanRequest.setter(Builder::savingsPlanOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanOfferingId").build()}).build();
    private static final SdkField<String> COMMITMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commitment").getter(CreateSavingsPlanRequest.getter(CreateSavingsPlanRequest::commitment)).setter(CreateSavingsPlanRequest.setter(Builder::commitment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitment").build()}).build();
    private static final SdkField<String> UPFRONT_PAYMENT_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("upfrontPaymentAmount").getter(CreateSavingsPlanRequest.getter(CreateSavingsPlanRequest::upfrontPaymentAmount)).setter(CreateSavingsPlanRequest.setter(Builder::upfrontPaymentAmount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upfrontPaymentAmount").build()}).build();
    private static final SdkField<Instant> PURCHASE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("purchaseTime").getter(CreateSavingsPlanRequest.getter(CreateSavingsPlanRequest::purchaseTime)).setter(CreateSavingsPlanRequest.setter(Builder::purchaseTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("purchaseTime").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateSavingsPlanRequest.getter(CreateSavingsPlanRequest::clientToken)).setter(CreateSavingsPlanRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateSavingsPlanRequest.getter(CreateSavingsPlanRequest::tags)).setter(CreateSavingsPlanRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_PLAN_OFFERING_ID_FIELD, COMMITMENT_FIELD, UPFRONT_PAYMENT_AMOUNT_FIELD, PURCHASE_TIME_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private final String savingsPlanOfferingId;
    private final String commitment;
    private final String upfrontPaymentAmount;
    private final Instant purchaseTime;
    private final String clientToken;
    private final Map<String, String> tags;

    private CreateSavingsPlanRequest(BuilderImpl builder) {
        super(builder);
        this.savingsPlanOfferingId = builder.savingsPlanOfferingId;
        this.commitment = builder.commitment;
        this.upfrontPaymentAmount = builder.upfrontPaymentAmount;
        this.purchaseTime = builder.purchaseTime;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String savingsPlanOfferingId() {
        return this.savingsPlanOfferingId;
    }

    public final String commitment() {
        return this.commitment;
    }

    public final String upfrontPaymentAmount() {
        return this.upfrontPaymentAmount;
    }

    public final Instant purchaseTime() {
        return this.purchaseTime;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPlanOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitment());
        hashCode = 31 * hashCode + Objects.hashCode(this.upfrontPaymentAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchaseTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSavingsPlanRequest)) {
            return false;
        }
        CreateSavingsPlanRequest other = (CreateSavingsPlanRequest)((Object)obj);
        return Objects.equals(this.savingsPlanOfferingId(), other.savingsPlanOfferingId()) && Objects.equals(this.commitment(), other.commitment()) && Objects.equals(this.upfrontPaymentAmount(), other.upfrontPaymentAmount()) && Objects.equals(this.purchaseTime(), other.purchaseTime()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSavingsPlanRequest").add("SavingsPlanOfferingId", (Object)this.savingsPlanOfferingId()).add("Commitment", (Object)this.commitment()).add("UpfrontPaymentAmount", (Object)this.upfrontPaymentAmount()).add("PurchaseTime", (Object)this.purchaseTime()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "savingsPlanOfferingId": {
                return Optional.ofNullable(clazz.cast(this.savingsPlanOfferingId()));
            }
            case "commitment": {
                return Optional.ofNullable(clazz.cast(this.commitment()));
            }
            case "upfrontPaymentAmount": {
                return Optional.ofNullable(clazz.cast(this.upfrontPaymentAmount()));
            }
            case "purchaseTime": {
                return Optional.ofNullable(clazz.cast(this.purchaseTime()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSavingsPlanRequest, T> g) {
        return obj -> g.apply((CreateSavingsPlanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SavingsplansRequest.BuilderImpl
    implements Builder {
        private String savingsPlanOfferingId;
        private String commitment;
        private String upfrontPaymentAmount;
        private Instant purchaseTime;
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSavingsPlanRequest model) {
            super(model);
            this.savingsPlanOfferingId(model.savingsPlanOfferingId);
            this.commitment(model.commitment);
            this.upfrontPaymentAmount(model.upfrontPaymentAmount);
            this.purchaseTime(model.purchaseTime);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getSavingsPlanOfferingId() {
            return this.savingsPlanOfferingId;
        }

        @Override
        public final Builder savingsPlanOfferingId(String savingsPlanOfferingId) {
            this.savingsPlanOfferingId = savingsPlanOfferingId;
            return this;
        }

        public final void setSavingsPlanOfferingId(String savingsPlanOfferingId) {
            this.savingsPlanOfferingId = savingsPlanOfferingId;
        }

        public final String getCommitment() {
            return this.commitment;
        }

        @Override
        public final Builder commitment(String commitment) {
            this.commitment = commitment;
            return this;
        }

        public final void setCommitment(String commitment) {
            this.commitment = commitment;
        }

        public final String getUpfrontPaymentAmount() {
            return this.upfrontPaymentAmount;
        }

        @Override
        public final Builder upfrontPaymentAmount(String upfrontPaymentAmount) {
            this.upfrontPaymentAmount = upfrontPaymentAmount;
            return this;
        }

        public final void setUpfrontPaymentAmount(String upfrontPaymentAmount) {
            this.upfrontPaymentAmount = upfrontPaymentAmount;
        }

        public final Instant getPurchaseTime() {
            return this.purchaseTime;
        }

        @Override
        public final Builder purchaseTime(Instant purchaseTime) {
            this.purchaseTime = purchaseTime;
            return this;
        }

        public final void setPurchaseTime(Instant purchaseTime) {
            this.purchaseTime = purchaseTime;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSavingsPlanRequest build() {
            return new CreateSavingsPlanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SavingsplansRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSavingsPlanRequest> {
        public Builder savingsPlanOfferingId(String var1);

        public Builder commitment(String var1);

        public Builder upfrontPaymentAmount(String var1);

        public Builder purchaseTime(Instant var1);

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

