/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobCompletionCriteria;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobObjective;
import software.amazon.awssdk.services.sagemaker.model.ProblemType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResolvedAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResolvedAttributes> {
    private static final SdkField<AutoMLJobObjective> AUTO_ML_JOB_OBJECTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoMLJobObjective").getter(ResolvedAttributes.getter(ResolvedAttributes::autoMLJobObjective)).setter(ResolvedAttributes.setter(Builder::autoMLJobObjective)).constructor(AutoMLJobObjective::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobObjective").build()}).build();
    private static final SdkField<String> PROBLEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProblemType").getter(ResolvedAttributes.getter(ResolvedAttributes::problemTypeAsString)).setter(ResolvedAttributes.setter(Builder::problemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProblemType").build()}).build();
    private static final SdkField<AutoMLJobCompletionCriteria> COMPLETION_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CompletionCriteria").getter(ResolvedAttributes.getter(ResolvedAttributes::completionCriteria)).setter(ResolvedAttributes.setter(Builder::completionCriteria)).constructor(AutoMLJobCompletionCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionCriteria").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ML_JOB_OBJECTIVE_FIELD, PROBLEM_TYPE_FIELD, COMPLETION_CRITERIA_FIELD));
    private static final long serialVersionUID = 1L;
    private final AutoMLJobObjective autoMLJobObjective;
    private final String problemType;
    private final AutoMLJobCompletionCriteria completionCriteria;

    private ResolvedAttributes(BuilderImpl builder) {
        this.autoMLJobObjective = builder.autoMLJobObjective;
        this.problemType = builder.problemType;
        this.completionCriteria = builder.completionCriteria;
    }

    public final AutoMLJobObjective autoMLJobObjective() {
        return this.autoMLJobObjective;
    }

    public final ProblemType problemType() {
        return ProblemType.fromValue(this.problemType);
    }

    public final String problemTypeAsString() {
        return this.problemType;
    }

    public final AutoMLJobCompletionCriteria completionCriteria() {
        return this.completionCriteria;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobObjective());
        hashCode = 31 * hashCode + Objects.hashCode(this.problemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionCriteria());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolvedAttributes)) {
            return false;
        }
        ResolvedAttributes other = (ResolvedAttributes)obj;
        return Objects.equals(this.autoMLJobObjective(), other.autoMLJobObjective()) && Objects.equals(this.problemTypeAsString(), other.problemTypeAsString()) && Objects.equals(this.completionCriteria(), other.completionCriteria());
    }

    public final String toString() {
        return ToString.builder((String)"ResolvedAttributes").add("AutoMLJobObjective", (Object)this.autoMLJobObjective()).add("ProblemType", (Object)this.problemTypeAsString()).add("CompletionCriteria", (Object)this.completionCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoMLJobObjective": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobObjective()));
            }
            case "ProblemType": {
                return Optional.ofNullable(clazz.cast(this.problemTypeAsString()));
            }
            case "CompletionCriteria": {
                return Optional.ofNullable(clazz.cast(this.completionCriteria()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolvedAttributes, T> g) {
        return obj -> g.apply((ResolvedAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AutoMLJobObjective autoMLJobObjective;
        private String problemType;
        private AutoMLJobCompletionCriteria completionCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolvedAttributes model) {
            this.autoMLJobObjective(model.autoMLJobObjective);
            this.problemType(model.problemType);
            this.completionCriteria(model.completionCriteria);
        }

        public final AutoMLJobObjective.Builder getAutoMLJobObjective() {
            return this.autoMLJobObjective != null ? this.autoMLJobObjective.toBuilder() : null;
        }

        @Override
        public final Builder autoMLJobObjective(AutoMLJobObjective autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective;
            return this;
        }

        public final void setAutoMLJobObjective(AutoMLJobObjective.BuilderImpl autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective != null ? autoMLJobObjective.build() : null;
        }

        public final String getProblemType() {
            return this.problemType;
        }

        @Override
        public final Builder problemType(String problemType) {
            this.problemType = problemType;
            return this;
        }

        @Override
        public final Builder problemType(ProblemType problemType) {
            this.problemType(problemType == null ? null : problemType.toString());
            return this;
        }

        public final void setProblemType(String problemType) {
            this.problemType = problemType;
        }

        public final AutoMLJobCompletionCriteria.Builder getCompletionCriteria() {
            return this.completionCriteria != null ? this.completionCriteria.toBuilder() : null;
        }

        @Override
        public final Builder completionCriteria(AutoMLJobCompletionCriteria completionCriteria) {
            this.completionCriteria = completionCriteria;
            return this;
        }

        public final void setCompletionCriteria(AutoMLJobCompletionCriteria.BuilderImpl completionCriteria) {
            this.completionCriteria = completionCriteria != null ? completionCriteria.build() : null;
        }

        public ResolvedAttributes build() {
            return new ResolvedAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResolvedAttributes> {
        public Builder autoMLJobObjective(AutoMLJobObjective var1);

        default public Builder autoMLJobObjective(Consumer<AutoMLJobObjective.Builder> autoMLJobObjective) {
            return this.autoMLJobObjective((AutoMLJobObjective)((AutoMLJobObjective.Builder)AutoMLJobObjective.builder().applyMutation(autoMLJobObjective)).build());
        }

        public Builder problemType(String var1);

        public Builder problemType(ProblemType var1);

        public Builder completionCriteria(AutoMLJobCompletionCriteria var1);

        default public Builder completionCriteria(Consumer<AutoMLJobCompletionCriteria.Builder> completionCriteria) {
            return this.completionCriteria((AutoMLJobCompletionCriteria)((AutoMLJobCompletionCriteria.Builder)AutoMLJobCompletionCriteria.builder().applyMutation(completionCriteria)).build());
        }
    }
}

