/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ProjectStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectSummary> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectName").getter(ProjectSummary.getter(ProjectSummary::projectName)).setter(ProjectSummary.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectName").build()}).build();
    private static final SdkField<String> PROJECT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectDescription").getter(ProjectSummary.getter(ProjectSummary::projectDescription)).setter(ProjectSummary.setter(Builder::projectDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectDescription").build()}).build();
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectArn").getter(ProjectSummary.getter(ProjectSummary::projectArn)).setter(ProjectSummary.setter(Builder::projectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectArn").build()}).build();
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectId").getter(ProjectSummary.getter(ProjectSummary::projectId)).setter(ProjectSummary.setter(Builder::projectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectId").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ProjectSummary.getter(ProjectSummary::creationTime)).setter(ProjectSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> PROJECT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectStatus").getter(ProjectSummary.getter(ProjectSummary::projectStatusAsString)).setter(ProjectSummary.setter(Builder::projectStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD, PROJECT_DESCRIPTION_FIELD, PROJECT_ARN_FIELD, PROJECT_ID_FIELD, CREATION_TIME_FIELD, PROJECT_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String projectName;
    private final String projectDescription;
    private final String projectArn;
    private final String projectId;
    private final Instant creationTime;
    private final String projectStatus;

    private ProjectSummary(BuilderImpl builder) {
        this.projectName = builder.projectName;
        this.projectDescription = builder.projectDescription;
        this.projectArn = builder.projectArn;
        this.projectId = builder.projectId;
        this.creationTime = builder.creationTime;
        this.projectStatus = builder.projectStatus;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String projectDescription() {
        return this.projectDescription;
    }

    public final String projectArn() {
        return this.projectArn;
    }

    public final String projectId() {
        return this.projectId;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final ProjectStatus projectStatus() {
        return ProjectStatus.fromValue(this.projectStatus);
    }

    public final String projectStatusAsString() {
        return this.projectStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectSummary)) {
            return false;
        }
        ProjectSummary other = (ProjectSummary)obj;
        return Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.projectDescription(), other.projectDescription()) && Objects.equals(this.projectArn(), other.projectArn()) && Objects.equals(this.projectId(), other.projectId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.projectStatusAsString(), other.projectStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ProjectSummary").add("ProjectName", (Object)this.projectName()).add("ProjectDescription", (Object)this.projectDescription()).add("ProjectArn", (Object)this.projectArn()).add("ProjectId", (Object)this.projectId()).add("CreationTime", (Object)this.creationTime()).add("ProjectStatus", (Object)this.projectStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "ProjectDescription": {
                return Optional.ofNullable(clazz.cast(this.projectDescription()));
            }
            case "ProjectArn": {
                return Optional.ofNullable(clazz.cast(this.projectArn()));
            }
            case "ProjectId": {
                return Optional.ofNullable(clazz.cast(this.projectId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ProjectStatus": {
                return Optional.ofNullable(clazz.cast(this.projectStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProjectSummary, T> g) {
        return obj -> g.apply((ProjectSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String projectName;
        private String projectDescription;
        private String projectArn;
        private String projectId;
        private Instant creationTime;
        private String projectStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectSummary model) {
            this.projectName(model.projectName);
            this.projectDescription(model.projectDescription);
            this.projectArn(model.projectArn);
            this.projectId(model.projectId);
            this.creationTime(model.creationTime);
            this.projectStatus(model.projectStatus);
        }

        public final String getProjectName() {
            return this.projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final String getProjectDescription() {
            return this.projectDescription;
        }

        @Override
        public final Builder projectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
            return this;
        }

        public final void setProjectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        public final String getProjectId() {
            return this.projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getProjectStatus() {
            return this.projectStatus;
        }

        @Override
        public final Builder projectStatus(String projectStatus) {
            this.projectStatus = projectStatus;
            return this;
        }

        @Override
        public final Builder projectStatus(ProjectStatus projectStatus) {
            this.projectStatus(projectStatus == null ? null : projectStatus.toString());
            return this;
        }

        public final void setProjectStatus(String projectStatus) {
            this.projectStatus = projectStatus;
        }

        public ProjectSummary build() {
            return new ProjectSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectSummary> {
        public Builder projectName(String var1);

        public Builder projectDescription(String var1);

        public Builder projectArn(String var1);

        public Builder projectId(String var1);

        public Builder creationTime(Instant var1);

        public Builder projectStatus(String var1);

        public Builder projectStatus(ProjectStatus var1);
    }
}

