/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.EndpointInput;
import software.amazon.awssdk.services.sagemaker.model.MonitoringGroundTruthS3Input;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelBiasJobInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelBiasJobInput> {
    private static final SdkField<EndpointInput> ENDPOINT_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointInput").getter(ModelBiasJobInput.getter(ModelBiasJobInput::endpointInput)).setter(ModelBiasJobInput.setter(Builder::endpointInput)).constructor(EndpointInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointInput").build()}).build();
    private static final SdkField<MonitoringGroundTruthS3Input> GROUND_TRUTH_S3_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GroundTruthS3Input").getter(ModelBiasJobInput.getter(ModelBiasJobInput::groundTruthS3Input)).setter(ModelBiasJobInput.setter(Builder::groundTruthS3Input)).constructor(MonitoringGroundTruthS3Input::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroundTruthS3Input").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_INPUT_FIELD, GROUND_TRUTH_S3_INPUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final EndpointInput endpointInput;
    private final MonitoringGroundTruthS3Input groundTruthS3Input;

    private ModelBiasJobInput(BuilderImpl builder) {
        this.endpointInput = builder.endpointInput;
        this.groundTruthS3Input = builder.groundTruthS3Input;
    }

    public final EndpointInput endpointInput() {
        return this.endpointInput;
    }

    public final MonitoringGroundTruthS3Input groundTruthS3Input() {
        return this.groundTruthS3Input;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.groundTruthS3Input());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelBiasJobInput)) {
            return false;
        }
        ModelBiasJobInput other = (ModelBiasJobInput)obj;
        return Objects.equals(this.endpointInput(), other.endpointInput()) && Objects.equals(this.groundTruthS3Input(), other.groundTruthS3Input());
    }

    public final String toString() {
        return ToString.builder((String)"ModelBiasJobInput").add("EndpointInput", (Object)this.endpointInput()).add("GroundTruthS3Input", (Object)this.groundTruthS3Input()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointInput": {
                return Optional.ofNullable(clazz.cast(this.endpointInput()));
            }
            case "GroundTruthS3Input": {
                return Optional.ofNullable(clazz.cast(this.groundTruthS3Input()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelBiasJobInput, T> g) {
        return obj -> g.apply((ModelBiasJobInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EndpointInput endpointInput;
        private MonitoringGroundTruthS3Input groundTruthS3Input;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelBiasJobInput model) {
            this.endpointInput(model.endpointInput);
            this.groundTruthS3Input(model.groundTruthS3Input);
        }

        public final EndpointInput.Builder getEndpointInput() {
            return this.endpointInput != null ? this.endpointInput.toBuilder() : null;
        }

        @Override
        public final Builder endpointInput(EndpointInput endpointInput) {
            this.endpointInput = endpointInput;
            return this;
        }

        public final void setEndpointInput(EndpointInput.BuilderImpl endpointInput) {
            this.endpointInput = endpointInput != null ? endpointInput.build() : null;
        }

        public final MonitoringGroundTruthS3Input.Builder getGroundTruthS3Input() {
            return this.groundTruthS3Input != null ? this.groundTruthS3Input.toBuilder() : null;
        }

        @Override
        public final Builder groundTruthS3Input(MonitoringGroundTruthS3Input groundTruthS3Input) {
            this.groundTruthS3Input = groundTruthS3Input;
            return this;
        }

        public final void setGroundTruthS3Input(MonitoringGroundTruthS3Input.BuilderImpl groundTruthS3Input) {
            this.groundTruthS3Input = groundTruthS3Input != null ? groundTruthS3Input.build() : null;
        }

        public ModelBiasJobInput build() {
            return new ModelBiasJobInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelBiasJobInput> {
        public Builder endpointInput(EndpointInput var1);

        default public Builder endpointInput(Consumer<EndpointInput.Builder> endpointInput) {
            return this.endpointInput((EndpointInput)((EndpointInput.Builder)EndpointInput.builder().applyMutation(endpointInput)).build());
        }

        public Builder groundTruthS3Input(MonitoringGroundTruthS3Input var1);

        default public Builder groundTruthS3Input(Consumer<MonitoringGroundTruthS3Input.Builder> groundTruthS3Input) {
            return this.groundTruthS3Input((MonitoringGroundTruthS3Input)((MonitoringGroundTruthS3Input.Builder)MonitoringGroundTruthS3Input.builder().applyMutation(groundTruthS3Input)).build());
        }
    }
}

