/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InputMode {
    PIPE("Pipe"),
    FILE("File"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InputMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InputMode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputMode> knownValues() {
        return Stream.of(InputMode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

