/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.JobStatus;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateJobStatusResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, UpdateJobStatusResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(UpdateJobStatusResponse.getter(UpdateJobStatusResponse::jobId)).setter(UpdateJobStatusResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").unmarshallLocationName("JobId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(UpdateJobStatusResponse.getter(UpdateJobStatusResponse::statusAsString)).setter(UpdateJobStatusResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("Status").build()}).build();
    private static final SdkField<String> STATUS_UPDATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusUpdateReason").getter(UpdateJobStatusResponse.getter(UpdateJobStatusResponse::statusUpdateReason)).setter(UpdateJobStatusResponse.setter(Builder::statusUpdateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusUpdateReason").unmarshallLocationName("StatusUpdateReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, STATUS_FIELD, STATUS_UPDATE_REASON_FIELD));
    private final String jobId;
    private final String status;
    private final String statusUpdateReason;

    private UpdateJobStatusResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.status = builder.status;
        this.statusUpdateReason = builder.statusUpdateReason;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusUpdateReason() {
        return this.statusUpdateReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusUpdateReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobStatusResponse)) {
            return false;
        }
        UpdateJobStatusResponse other = (UpdateJobStatusResponse)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusUpdateReason(), other.statusUpdateReason());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateJobStatusResponse").add("JobId", (Object)this.jobId()).add("Status", (Object)this.statusAsString()).add("StatusUpdateReason", (Object)this.statusUpdateReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusUpdateReason": {
                return Optional.ofNullable(clazz.cast(this.statusUpdateReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateJobStatusResponse, T> g) {
        return obj -> g.apply((UpdateJobStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private String jobId;
        private String status;
        private String statusUpdateReason;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobStatusResponse model) {
            super(model);
            this.jobId(model.jobId);
            this.status(model.status);
            this.statusUpdateReason(model.statusUpdateReason);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusUpdateReason() {
            return this.statusUpdateReason;
        }

        @Override
        public final Builder statusUpdateReason(String statusUpdateReason) {
            this.statusUpdateReason = statusUpdateReason;
            return this;
        }

        public final void setStatusUpdateReason(String statusUpdateReason) {
            this.statusUpdateReason = statusUpdateReason;
        }

        @Override
        public UpdateJobStatusResponse build() {
            return new UpdateJobStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateJobStatusResponse> {
        public Builder jobId(String var1);

        public Builder status(String var1);

        public Builder status(JobStatus var1);

        public Builder statusUpdateReason(String var1);
    }
}

