/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStorageLensConfigurationEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListStorageLensConfigurationEntry> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ListStorageLensConfigurationEntry.getter(ListStorageLensConfigurationEntry::id)).setter(ListStorageLensConfigurationEntry.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> STORAGE_LENS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageLensArn").getter(ListStorageLensConfigurationEntry.getter(ListStorageLensConfigurationEntry::storageLensArn)).setter(ListStorageLensConfigurationEntry.setter(Builder::storageLensArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLensArn").unmarshallLocationName("StorageLensArn").build()}).build();
    private static final SdkField<String> HOME_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HomeRegion").getter(ListStorageLensConfigurationEntry.getter(ListStorageLensConfigurationEntry::homeRegion)).setter(ListStorageLensConfigurationEntry.setter(Builder::homeRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegion").unmarshallLocationName("HomeRegion").build()}).build();
    private static final SdkField<Boolean> IS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsEnabled").getter(ListStorageLensConfigurationEntry.getter(ListStorageLensConfigurationEntry::isEnabled)).setter(ListStorageLensConfigurationEntry.setter(Builder::isEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsEnabled").unmarshallLocationName("IsEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STORAGE_LENS_ARN_FIELD, HOME_REGION_FIELD, IS_ENABLED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String storageLensArn;
    private final String homeRegion;
    private final Boolean isEnabled;

    private ListStorageLensConfigurationEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.storageLensArn = builder.storageLensArn;
        this.homeRegion = builder.homeRegion;
        this.isEnabled = builder.isEnabled;
    }

    public final String id() {
        return this.id;
    }

    public final String storageLensArn() {
        return this.storageLensArn;
    }

    public final String homeRegion() {
        return this.homeRegion;
    }

    public final Boolean isEnabled() {
        return this.isEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageLensArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.homeRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.isEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStorageLensConfigurationEntry)) {
            return false;
        }
        ListStorageLensConfigurationEntry other = (ListStorageLensConfigurationEntry)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.storageLensArn(), other.storageLensArn()) && Objects.equals(this.homeRegion(), other.homeRegion()) && Objects.equals(this.isEnabled(), other.isEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"ListStorageLensConfigurationEntry").add("Id", (Object)this.id()).add("StorageLensArn", (Object)this.storageLensArn()).add("HomeRegion", (Object)this.homeRegion()).add("IsEnabled", (Object)this.isEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "StorageLensArn": {
                return Optional.ofNullable(clazz.cast(this.storageLensArn()));
            }
            case "HomeRegion": {
                return Optional.ofNullable(clazz.cast(this.homeRegion()));
            }
            case "IsEnabled": {
                return Optional.ofNullable(clazz.cast(this.isEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStorageLensConfigurationEntry, T> g) {
        return obj -> g.apply((ListStorageLensConfigurationEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String storageLensArn;
        private String homeRegion;
        private Boolean isEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStorageLensConfigurationEntry model) {
            this.id(model.id);
            this.storageLensArn(model.storageLensArn);
            this.homeRegion(model.homeRegion);
            this.isEnabled(model.isEnabled);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getStorageLensArn() {
            return this.storageLensArn;
        }

        @Override
        public final Builder storageLensArn(String storageLensArn) {
            this.storageLensArn = storageLensArn;
            return this;
        }

        public final void setStorageLensArn(String storageLensArn) {
            this.storageLensArn = storageLensArn;
        }

        public final String getHomeRegion() {
            return this.homeRegion;
        }

        @Override
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        public final Boolean getIsEnabled() {
            return this.isEnabled;
        }

        @Override
        public final Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public final void setIsEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public ListStorageLensConfigurationEntry build() {
            return new ListStorageLensConfigurationEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListStorageLensConfigurationEntry> {
        public Builder id(String var1);

        public Builder storageLensArn(String var1);

        public Builder homeRegion(String var1);

        public Builder isEnabled(Boolean var1);
    }
}

