/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.xpath.XPath;
import org.w3c.dom.Node;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.runtime.transform.AbstractErrorUnmarshaller;
import software.amazon.awssdk.core.util.xml.XpathUtils;
import software.amazon.awssdk.utils.StringUtils;

@SdkInternalApi
public abstract class S3ExceptionUnmarshaller
extends AbstractErrorUnmarshaller<AwsServiceException, Node> {
    private final String errorCode;

    S3ExceptionUnmarshaller(Class<? extends AwsServiceException> exceptionClass, String errorCode) {
        super(exceptionClass);
        this.errorCode = errorCode;
    }

    public AwsServiceException unmarshall(Node in) throws Exception {
        XPath xpath = XpathUtils.xpath();
        String error = XpathUtils.asString((String)"Error/Code", (Node)in, (XPath)xpath);
        String requestId = XpathUtils.asString((String)"Error/RequestId", (Node)in, (XPath)xpath);
        String message = XpathUtils.asString((String)"Error/Message", (Node)in, (XPath)xpath);
        if (this.errorCode != null && !StringUtils.equals((String)error, (String)this.errorCode)) {
            return null;
        }
        AwsServiceException.Builder exception = ((AwsServiceException)this.newException(message)).toBuilder();
        AwsErrorDetails awsErrorDetails = AwsErrorDetails.builder().errorMessage(message).errorCode(this.errorCode).build();
        return exception.requestId(requestId).awsErrorDetails(awsErrorDetails).build();
    }
}

