/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.core.util.xml.XmlWriter;
import software.amazon.awssdk.services.s3.model.CloudFunctionConfiguration;
import software.amazon.awssdk.services.s3.model.NotificationConfigurationDeprecated;
import software.amazon.awssdk.services.s3.model.PutBucketNotificationRequest;
import software.amazon.awssdk.services.s3.model.QueueConfigurationDeprecated;
import software.amazon.awssdk.services.s3.model.TopicConfigurationDeprecated;
import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.utils.StringInputStream;

public class PutBucketNotificationRequestMarshaller
implements Marshaller<Request<PutBucketNotificationRequest>, PutBucketNotificationRequest> {
    public Request<PutBucketNotificationRequest> marshall(PutBucketNotificationRequest putBucketNotificationRequest) {
        if (putBucketNotificationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)putBucketNotificationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putBucketNotificationRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringConversion.fromString((String)putBucketNotificationRequest.contentMD5()));
        }
        String uriResourcePath = "/{Bucket}?notification";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketNotificationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            NotificationConfigurationDeprecated notificationConfiguration = putBucketNotificationRequest.notificationConfiguration();
            if (notificationConfiguration != null) {
                CloudFunctionConfiguration cloudFunctionConfiguration;
                QueueConfigurationDeprecated queueConfiguration;
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("NotificationConfiguration");
                TopicConfigurationDeprecated topicConfiguration = notificationConfiguration.topicConfiguration();
                if (topicConfiguration != null) {
                    List<String> topicConfigurationDeprecatedEventsList;
                    xmlWriter.startElement("TopicConfiguration");
                    if (topicConfiguration.id() != null) {
                        xmlWriter.startElement("Id").value(topicConfiguration.id()).endElement();
                    }
                    if (!(topicConfigurationDeprecatedEventsList = topicConfiguration.eventsAsStrings()).isEmpty() || !(topicConfigurationDeprecatedEventsList instanceof SdkAutoConstructList)) {
                        for (String string : topicConfigurationDeprecatedEventsList) {
                            xmlWriter.startElement("Event");
                            xmlWriter.value(string);
                            xmlWriter.endElement();
                        }
                    }
                    if (topicConfiguration.eventAsString() != null) {
                        xmlWriter.startElement("Event").value(topicConfiguration.eventAsString()).endElement();
                    }
                    if (topicConfiguration.topic() != null) {
                        xmlWriter.startElement("Topic").value(topicConfiguration.topic()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((queueConfiguration = notificationConfiguration.queueConfiguration()) != null) {
                    List<String> queueConfigurationDeprecatedEventsList;
                    xmlWriter.startElement("QueueConfiguration");
                    if (queueConfiguration.id() != null) {
                        xmlWriter.startElement("Id").value(queueConfiguration.id()).endElement();
                    }
                    if (queueConfiguration.eventAsString() != null) {
                        xmlWriter.startElement("Event").value(queueConfiguration.eventAsString()).endElement();
                    }
                    if (!(queueConfigurationDeprecatedEventsList = queueConfiguration.eventsAsStrings()).isEmpty() || !(queueConfigurationDeprecatedEventsList instanceof SdkAutoConstructList)) {
                        for (String queueConfigurationDeprecatedEventsListValue : queueConfigurationDeprecatedEventsList) {
                            xmlWriter.startElement("Event");
                            xmlWriter.value(queueConfigurationDeprecatedEventsListValue);
                            xmlWriter.endElement();
                        }
                    }
                    if (queueConfiguration.queue() != null) {
                        xmlWriter.startElement("Queue").value(queueConfiguration.queue()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((cloudFunctionConfiguration = notificationConfiguration.cloudFunctionConfiguration()) != null) {
                    List<String> list;
                    xmlWriter.startElement("CloudFunctionConfiguration");
                    if (cloudFunctionConfiguration.id() != null) {
                        xmlWriter.startElement("Id").value(cloudFunctionConfiguration.id()).endElement();
                    }
                    if (cloudFunctionConfiguration.eventAsString() != null) {
                        xmlWriter.startElement("Event").value(cloudFunctionConfiguration.eventAsString()).endElement();
                    }
                    if (!(list = cloudFunctionConfiguration.eventsAsStrings()).isEmpty() || !(list instanceof SdkAutoConstructList)) {
                        for (String cloudFunctionConfigurationEventsListValue : list) {
                            xmlWriter.startElement("Event");
                            xmlWriter.value(cloudFunctionConfigurationEventsListValue);
                            xmlWriter.endElement();
                        }
                    }
                    if (cloudFunctionConfiguration.cloudFunction() != null) {
                        xmlWriter.startElement("CloudFunction").value(cloudFunctionConfiguration.cloudFunction()).endElement();
                    }
                    if (cloudFunctionConfiguration.invocationRole() != null) {
                        xmlWriter.startElement("InvocationRole").value(cloudFunctionConfiguration.invocationRole()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }
        return request;
    }
}

