/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;

public class AbortMultipartUploadRequestMarshaller
implements Marshaller<Request<AbortMultipartUploadRequest>, AbortMultipartUploadRequest> {
    public Request<AbortMultipartUploadRequest> marshall(AbortMultipartUploadRequest abortMultipartUploadRequest) {
        if (abortMultipartUploadRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)abortMultipartUploadRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (abortMultipartUploadRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringConversion.fromString((String)abortMultipartUploadRequest.requestPayerAsString()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", abortMultipartUploadRequest.bucket());
        uriResourcePath = PathMarshaller.GREEDY.marshall(uriResourcePath, "Key", abortMultipartUploadRequest.key());
        request.setResourcePath(uriResourcePath);
        if (abortMultipartUploadRequest.uploadId() != null) {
            request.addParameter("uploadId", StringConversion.fromString((String)abortMultipartUploadRequest.uploadId()));
        }
        return request;
    }
}

