/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.s3.model.Protocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Redirect
implements ToCopyableBuilder<Builder, Redirect> {
    private final String hostName;
    private final String httpRedirectCode;
    private final String protocol;
    private final String replaceKeyPrefixWith;
    private final String replaceKeyWith;

    private Redirect(BuilderImpl builder) {
        this.hostName = builder.hostName;
        this.httpRedirectCode = builder.httpRedirectCode;
        this.protocol = builder.protocol;
        this.replaceKeyPrefixWith = builder.replaceKeyPrefixWith;
        this.replaceKeyWith = builder.replaceKeyWith;
    }

    public String hostName() {
        return this.hostName;
    }

    public String httpRedirectCode() {
        return this.httpRedirectCode;
    }

    public Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public String protocolAsString() {
        return this.protocol;
    }

    public String replaceKeyPrefixWith() {
        return this.replaceKeyPrefixWith;
    }

    public String replaceKeyWith() {
        return this.replaceKeyWith;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostName());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpRedirectCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.replaceKeyPrefixWith());
        hashCode = 31 * hashCode + Objects.hashCode(this.replaceKeyWith());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Redirect)) {
            return false;
        }
        Redirect other = (Redirect)obj;
        return Objects.equals(this.hostName(), other.hostName()) && Objects.equals(this.httpRedirectCode(), other.httpRedirectCode()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.replaceKeyPrefixWith(), other.replaceKeyPrefixWith()) && Objects.equals(this.replaceKeyWith(), other.replaceKeyWith());
    }

    public String toString() {
        return ToString.builder((String)"Redirect").add("HostName", (Object)this.hostName()).add("HttpRedirectCode", (Object)this.httpRedirectCode()).add("Protocol", (Object)this.protocolAsString()).add("ReplaceKeyPrefixWith", (Object)this.replaceKeyPrefixWith()).add("ReplaceKeyWith", (Object)this.replaceKeyWith()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostName": {
                return Optional.ofNullable(clazz.cast(this.hostName()));
            }
            case "HttpRedirectCode": {
                return Optional.ofNullable(clazz.cast(this.httpRedirectCode()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "ReplaceKeyPrefixWith": {
                return Optional.ofNullable(clazz.cast(this.replaceKeyPrefixWith()));
            }
            case "ReplaceKeyWith": {
                return Optional.ofNullable(clazz.cast(this.replaceKeyWith()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String hostName;
        private String httpRedirectCode;
        private String protocol;
        private String replaceKeyPrefixWith;
        private String replaceKeyWith;

        private BuilderImpl() {
        }

        private BuilderImpl(Redirect model) {
            this.hostName(model.hostName);
            this.httpRedirectCode(model.httpRedirectCode);
            this.protocol(model.protocol);
            this.replaceKeyPrefixWith(model.replaceKeyPrefixWith);
            this.replaceKeyWith(model.replaceKeyWith);
        }

        public final String getHostName() {
            return this.hostName;
        }

        @Override
        public final Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public final void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public final String getHttpRedirectCode() {
            return this.httpRedirectCode;
        }

        @Override
        public final Builder httpRedirectCode(String httpRedirectCode) {
            this.httpRedirectCode = httpRedirectCode;
            return this;
        }

        public final void setHttpRedirectCode(String httpRedirectCode) {
            this.httpRedirectCode = httpRedirectCode;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getReplaceKeyPrefixWith() {
            return this.replaceKeyPrefixWith;
        }

        @Override
        public final Builder replaceKeyPrefixWith(String replaceKeyPrefixWith) {
            this.replaceKeyPrefixWith = replaceKeyPrefixWith;
            return this;
        }

        public final void setReplaceKeyPrefixWith(String replaceKeyPrefixWith) {
            this.replaceKeyPrefixWith = replaceKeyPrefixWith;
        }

        public final String getReplaceKeyWith() {
            return this.replaceKeyWith;
        }

        @Override
        public final Builder replaceKeyWith(String replaceKeyWith) {
            this.replaceKeyWith = replaceKeyWith;
            return this;
        }

        public final void setReplaceKeyWith(String replaceKeyWith) {
            this.replaceKeyWith = replaceKeyWith;
        }

        public Redirect build() {
            return new Redirect(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Redirect> {
        public Builder hostName(String var1);

        public Builder httpRedirectCode(String var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder replaceKeyPrefixWith(String var1);

        public Builder replaceKeyWith(String var1);
    }
}

