/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InventoryFormat {
    CSV("CSV"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InventoryFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InventoryFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InventoryFormat.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InventoryFormat> knownValues() {
        return Stream.of(InventoryFormat.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

