/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.ArnsCopier;
import software.amazon.awssdk.services.robomaker.model.RoboMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteWorldsResponse
extends RoboMakerResponse
implements ToCopyableBuilder<Builder, BatchDeleteWorldsResponse> {
    private static final SdkField<List<String>> UNPROCESSED_WORLDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("unprocessedWorlds").getter(BatchDeleteWorldsResponse.getter(BatchDeleteWorldsResponse::unprocessedWorlds)).setter(BatchDeleteWorldsResponse.setter(Builder::unprocessedWorlds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unprocessedWorlds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNPROCESSED_WORLDS_FIELD));
    private final List<String> unprocessedWorlds;

    private BatchDeleteWorldsResponse(BuilderImpl builder) {
        super(builder);
        this.unprocessedWorlds = builder.unprocessedWorlds;
    }

    public final boolean hasUnprocessedWorlds() {
        return this.unprocessedWorlds != null && !(this.unprocessedWorlds instanceof SdkAutoConstructList);
    }

    public final List<String> unprocessedWorlds() {
        return this.unprocessedWorlds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedWorlds() ? this.unprocessedWorlds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteWorldsResponse)) {
            return false;
        }
        BatchDeleteWorldsResponse other = (BatchDeleteWorldsResponse)((Object)obj);
        return this.hasUnprocessedWorlds() == other.hasUnprocessedWorlds() && Objects.equals(this.unprocessedWorlds(), other.unprocessedWorlds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteWorldsResponse").add("UnprocessedWorlds", this.hasUnprocessedWorlds() ? this.unprocessedWorlds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "unprocessedWorlds": {
                return Optional.ofNullable(clazz.cast(this.unprocessedWorlds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteWorldsResponse, T> g) {
        return obj -> g.apply((BatchDeleteWorldsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerResponse.BuilderImpl
    implements Builder {
        private List<String> unprocessedWorlds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteWorldsResponse model) {
            super(model);
            this.unprocessedWorlds(model.unprocessedWorlds);
        }

        public final Collection<String> getUnprocessedWorlds() {
            if (this.unprocessedWorlds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.unprocessedWorlds;
        }

        @Override
        public final Builder unprocessedWorlds(Collection<String> unprocessedWorlds) {
            this.unprocessedWorlds = ArnsCopier.copy(unprocessedWorlds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedWorlds(String ... unprocessedWorlds) {
            this.unprocessedWorlds(Arrays.asList(unprocessedWorlds));
            return this;
        }

        public final void setUnprocessedWorlds(Collection<String> unprocessedWorlds) {
            this.unprocessedWorlds = ArnsCopier.copy(unprocessedWorlds);
        }

        @Override
        public BatchDeleteWorldsResponse build() {
            return new BatchDeleteWorldsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteWorldsResponse> {
        public Builder unprocessedWorlds(Collection<String> var1);

        public Builder unprocessedWorlds(String ... var1);
    }
}

