/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroupstaggingapi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.TargetIdType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Summary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Summary> {
    private static final SdkField<String> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUpdated").getter(Summary.getter(Summary::lastUpdated)).setter(Summary.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()}).build();
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetId").getter(Summary.getter(Summary::targetId)).setter(Summary.setter(Builder::targetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()}).build();
    private static final SdkField<String> TARGET_ID_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetIdType").getter(Summary.getter(Summary::targetIdTypeAsString)).setter(Summary.setter(Builder::targetIdType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetIdType").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(Summary.getter(Summary::region)).setter(Summary.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(Summary.getter(Summary::resourceType)).setter(Summary.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<Long> NON_COMPLIANT_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NonCompliantResources").getter(Summary.getter(Summary::nonCompliantResources)).setter(Summary.setter(Builder::nonCompliantResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonCompliantResources").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_UPDATED_FIELD, TARGET_ID_FIELD, TARGET_ID_TYPE_FIELD, REGION_FIELD, RESOURCE_TYPE_FIELD, NON_COMPLIANT_RESOURCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String lastUpdated;
    private final String targetId;
    private final String targetIdType;
    private final String region;
    private final String resourceType;
    private final Long nonCompliantResources;

    private Summary(BuilderImpl builder) {
        this.lastUpdated = builder.lastUpdated;
        this.targetId = builder.targetId;
        this.targetIdType = builder.targetIdType;
        this.region = builder.region;
        this.resourceType = builder.resourceType;
        this.nonCompliantResources = builder.nonCompliantResources;
    }

    public final String lastUpdated() {
        return this.lastUpdated;
    }

    public final String targetId() {
        return this.targetId;
    }

    public final TargetIdType targetIdType() {
        return TargetIdType.fromValue(this.targetIdType);
    }

    public final String targetIdTypeAsString() {
        return this.targetIdType;
    }

    public final String region() {
        return this.region;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final Long nonCompliantResources() {
        return this.nonCompliantResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetIdTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonCompliantResources());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Summary)) {
            return false;
        }
        Summary other = (Summary)obj;
        return Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.targetId(), other.targetId()) && Objects.equals(this.targetIdTypeAsString(), other.targetIdTypeAsString()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.nonCompliantResources(), other.nonCompliantResources());
    }

    public final String toString() {
        return ToString.builder((String)"Summary").add("LastUpdated", (Object)this.lastUpdated()).add("TargetId", (Object)this.targetId()).add("TargetIdType", (Object)this.targetIdTypeAsString()).add("Region", (Object)this.region()).add("ResourceType", (Object)this.resourceType()).add("NonCompliantResources", (Object)this.nonCompliantResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "TargetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
            case "TargetIdType": {
                return Optional.ofNullable(clazz.cast(this.targetIdTypeAsString()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "NonCompliantResources": {
                return Optional.ofNullable(clazz.cast(this.nonCompliantResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Summary, T> g) {
        return obj -> g.apply((Summary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lastUpdated;
        private String targetId;
        private String targetIdType;
        private String region;
        private String resourceType;
        private Long nonCompliantResources;

        private BuilderImpl() {
        }

        private BuilderImpl(Summary model) {
            this.lastUpdated(model.lastUpdated);
            this.targetId(model.targetId);
            this.targetIdType(model.targetIdType);
            this.region(model.region);
            this.resourceType(model.resourceType);
            this.nonCompliantResources(model.nonCompliantResources);
        }

        public final String getLastUpdated() {
            return this.lastUpdated;
        }

        @Override
        public final Builder lastUpdated(String lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final void setLastUpdated(String lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public final String getTargetId() {
            return this.targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        public final String getTargetIdType() {
            return this.targetIdType;
        }

        @Override
        public final Builder targetIdType(String targetIdType) {
            this.targetIdType = targetIdType;
            return this;
        }

        @Override
        public final Builder targetIdType(TargetIdType targetIdType) {
            this.targetIdType(targetIdType == null ? null : targetIdType.toString());
            return this;
        }

        public final void setTargetIdType(String targetIdType) {
            this.targetIdType = targetIdType;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Long getNonCompliantResources() {
            return this.nonCompliantResources;
        }

        @Override
        public final Builder nonCompliantResources(Long nonCompliantResources) {
            this.nonCompliantResources = nonCompliantResources;
            return this;
        }

        public final void setNonCompliantResources(Long nonCompliantResources) {
            this.nonCompliantResources = nonCompliantResources;
        }

        public Summary build() {
            return new Summary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Summary> {
        public Builder lastUpdated(String var1);

        public Builder targetId(String var1);

        public Builder targetIdType(String var1);

        public Builder targetIdType(TargetIdType var1);

        public Builder region(String var1);

        public Builder resourceType(String var1);

        public Builder nonCompliantResources(Long var1);
    }
}

