/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroupstaggingapi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.ResourceGroupsTaggingApiResponse;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.Summary;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.SummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetComplianceSummaryResponse
extends ResourceGroupsTaggingApiResponse
implements ToCopyableBuilder<Builder, GetComplianceSummaryResponse> {
    private static final SdkField<List<Summary>> SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SummaryList").getter(GetComplianceSummaryResponse.getter(GetComplianceSummaryResponse::summaryList)).setter(GetComplianceSummaryResponse.setter(Builder::summaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Summary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaginationToken").getter(GetComplianceSummaryResponse.getter(GetComplianceSummaryResponse::paginationToken)).setter(GetComplianceSummaryResponse.setter(Builder::paginationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_LIST_FIELD, PAGINATION_TOKEN_FIELD));
    private final List<Summary> summaryList;
    private final String paginationToken;

    private GetComplianceSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.summaryList = builder.summaryList;
        this.paginationToken = builder.paginationToken;
    }

    public final boolean hasSummaryList() {
        return this.summaryList != null && !(this.summaryList instanceof SdkAutoConstructList);
    }

    public final List<Summary> summaryList() {
        return this.summaryList;
    }

    public final String paginationToken() {
        return this.paginationToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSummaryList() ? this.summaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.paginationToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComplianceSummaryResponse)) {
            return false;
        }
        GetComplianceSummaryResponse other = (GetComplianceSummaryResponse)((Object)obj);
        return this.hasSummaryList() == other.hasSummaryList() && Objects.equals(this.summaryList(), other.summaryList()) && Objects.equals(this.paginationToken(), other.paginationToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetComplianceSummaryResponse").add("SummaryList", this.hasSummaryList() ? this.summaryList() : null).add("PaginationToken", (Object)this.paginationToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SummaryList": {
                return Optional.ofNullable(clazz.cast(this.summaryList()));
            }
            case "PaginationToken": {
                return Optional.ofNullable(clazz.cast(this.paginationToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetComplianceSummaryResponse, T> g) {
        return obj -> g.apply((GetComplianceSummaryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceGroupsTaggingApiResponse.BuilderImpl
    implements Builder {
        private List<Summary> summaryList = DefaultSdkAutoConstructList.getInstance();
        private String paginationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComplianceSummaryResponse model) {
            super(model);
            this.summaryList(model.summaryList);
            this.paginationToken(model.paginationToken);
        }

        public final List<Summary.Builder> getSummaryList() {
            List<Summary.Builder> result = SummaryListCopier.copyToBuilder(this.summaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder summaryList(Collection<Summary> summaryList) {
            this.summaryList = SummaryListCopier.copy(summaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaryList(Summary ... summaryList) {
            this.summaryList(Arrays.asList(summaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaryList(Consumer<Summary.Builder> ... summaryList) {
            this.summaryList(Stream.of(summaryList).map(c -> (Summary)((Summary.Builder)Summary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSummaryList(Collection<Summary.BuilderImpl> summaryList) {
            this.summaryList = SummaryListCopier.copyFromBuilder(summaryList);
        }

        public final String getPaginationToken() {
            return this.paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        public GetComplianceSummaryResponse build() {
            return new GetComplianceSummaryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResourceGroupsTaggingApiResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetComplianceSummaryResponse> {
        public Builder summaryList(Collection<Summary> var1);

        public Builder summaryList(Summary ... var1);

        public Builder summaryList(Consumer<Summary.Builder> ... var1);

        public Builder paginationToken(String var1);
    }
}

