/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.TrainingData;
import software.amazon.awssdk.services.rekognition.model.ValidationData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrainingDataResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrainingDataResult> {
    private static final SdkField<TrainingData> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Input").getter(TrainingDataResult.getter(TrainingDataResult::input)).setter(TrainingDataResult.setter(Builder::input)).constructor(TrainingData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()}).build();
    private static final SdkField<TrainingData> OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Output").getter(TrainingDataResult.getter(TrainingDataResult::output)).setter(TrainingDataResult.setter(Builder::output)).constructor(TrainingData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Output").build()}).build();
    private static final SdkField<ValidationData> VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Validation").getter(TrainingDataResult.getter(TrainingDataResult::validation)).setter(TrainingDataResult.setter(Builder::validation)).constructor(ValidationData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD, OUTPUT_FIELD, VALIDATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final TrainingData input;
    private final TrainingData output;
    private final ValidationData validation;

    private TrainingDataResult(BuilderImpl builder) {
        this.input = builder.input;
        this.output = builder.output;
        this.validation = builder.validation;
    }

    public final TrainingData input() {
        return this.input;
    }

    public final TrainingData output() {
        return this.output;
    }

    public final ValidationData validation() {
        return this.validation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.output());
        hashCode = 31 * hashCode + Objects.hashCode(this.validation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingDataResult)) {
            return false;
        }
        TrainingDataResult other = (TrainingDataResult)obj;
        return Objects.equals(this.input(), other.input()) && Objects.equals(this.output(), other.output()) && Objects.equals(this.validation(), other.validation());
    }

    public final String toString() {
        return ToString.builder((String)"TrainingDataResult").add("Input", (Object)this.input()).add("Output", (Object)this.output()).add("Validation", (Object)this.validation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "Output": {
                return Optional.ofNullable(clazz.cast(this.output()));
            }
            case "Validation": {
                return Optional.ofNullable(clazz.cast(this.validation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrainingDataResult, T> g) {
        return obj -> g.apply((TrainingDataResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TrainingData input;
        private TrainingData output;
        private ValidationData validation;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingDataResult model) {
            this.input(model.input);
            this.output(model.output);
            this.validation(model.validation);
        }

        public final TrainingData.Builder getInput() {
            return this.input != null ? this.input.toBuilder() : null;
        }

        @Override
        public final Builder input(TrainingData input) {
            this.input = input;
            return this;
        }

        public final void setInput(TrainingData.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        public final TrainingData.Builder getOutput() {
            return this.output != null ? this.output.toBuilder() : null;
        }

        @Override
        public final Builder output(TrainingData output) {
            this.output = output;
            return this;
        }

        public final void setOutput(TrainingData.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        public final ValidationData.Builder getValidation() {
            return this.validation != null ? this.validation.toBuilder() : null;
        }

        @Override
        public final Builder validation(ValidationData validation) {
            this.validation = validation;
            return this;
        }

        public final void setValidation(ValidationData.BuilderImpl validation) {
            this.validation = validation != null ? validation.build() : null;
        }

        public TrainingDataResult build() {
            return new TrainingDataResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrainingDataResult> {
        public Builder input(TrainingData var1);

        default public Builder input(Consumer<TrainingData.Builder> input) {
            return this.input((TrainingData)((TrainingData.Builder)TrainingData.builder().applyMutation(input)).build());
        }

        public Builder output(TrainingData var1);

        default public Builder output(Consumer<TrainingData.Builder> output) {
            return this.output((TrainingData)((TrainingData.Builder)TrainingData.builder().applyMutation(output)).build());
        }

        public Builder validation(ValidationData var1);

        default public Builder validation(Consumer<ValidationData.Builder> validation) {
            return this.validation((ValidationData)((ValidationData.Builder)ValidationData.builder().applyMutation(validation)).build());
        }
    }
}

