/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessResponse;
import software.amazon.awssdk.services.redshift.model.EndpointAccess;

public class DescribeEndpointAccessPublisher
implements SdkPublisher<DescribeEndpointAccessResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeEndpointAccessRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEndpointAccessPublisher(RedshiftAsyncClient client, DescribeEndpointAccessRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEndpointAccessPublisher(RedshiftAsyncClient client, DescribeEndpointAccessRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEndpointAccessResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEndpointAccessResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EndpointAccess> endpointAccessList() {
        Function<DescribeEndpointAccessResponse, Iterator> getIterator = response -> {
            if (response != null && response.endpointAccessList() != null) {
                return response.endpointAccessList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeEndpointAccessResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeEndpointAccessResponseFetcher
    implements AsyncPageFetcher<DescribeEndpointAccessResponse> {
        private DescribeEndpointAccessResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEndpointAccessResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeEndpointAccessResponse> nextPage(DescribeEndpointAccessResponse previousPage) {
            if (previousPage == null) {
                return DescribeEndpointAccessPublisher.this.client.describeEndpointAccess(DescribeEndpointAccessPublisher.this.firstRequest);
            }
            return DescribeEndpointAccessPublisher.this.client.describeEndpointAccess((DescribeEndpointAccessRequest)((Object)DescribeEndpointAccessPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

