/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rdsdata.model.Field;
import software.amazon.awssdk.services.rdsdata.model.TypeHint;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SqlParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SqlParameter> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(SqlParameter.getter(SqlParameter::name)).setter(SqlParameter.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_HINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("typeHint").getter(SqlParameter.getter(SqlParameter::typeHintAsString)).setter(SqlParameter.setter(Builder::typeHint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeHint").build()}).build();
    private static final SdkField<Field> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("value").getter(SqlParameter.getter(SqlParameter::value)).setter(SqlParameter.setter(Builder::value)).constructor(Field::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_HINT_FIELD, VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String typeHint;
    private final Field value;

    private SqlParameter(BuilderImpl builder) {
        this.name = builder.name;
        this.typeHint = builder.typeHint;
        this.value = builder.value;
    }

    public final String name() {
        return this.name;
    }

    public final TypeHint typeHint() {
        return TypeHint.fromValue(this.typeHint);
    }

    public final String typeHintAsString() {
        return this.typeHint;
    }

    public final Field value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeHintAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlParameter)) {
            return false;
        }
        SqlParameter other = (SqlParameter)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeHintAsString(), other.typeHintAsString()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"SqlParameter").add("Name", (Object)this.name()).add("TypeHint", (Object)this.typeHintAsString()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "typeHint": {
                return Optional.ofNullable(clazz.cast(this.typeHintAsString()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SqlParameter, T> g) {
        return obj -> g.apply((SqlParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String typeHint;
        private Field value;

        private BuilderImpl() {
        }

        private BuilderImpl(SqlParameter model) {
            this.name(model.name);
            this.typeHint(model.typeHint);
            this.value(model.value);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getTypeHint() {
            return this.typeHint;
        }

        @Override
        public final Builder typeHint(String typeHint) {
            this.typeHint = typeHint;
            return this;
        }

        @Override
        public final Builder typeHint(TypeHint typeHint) {
            this.typeHint(typeHint == null ? null : typeHint.toString());
            return this;
        }

        public final void setTypeHint(String typeHint) {
            this.typeHint = typeHint;
        }

        public final Field.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        @Override
        public final Builder value(Field value) {
            this.value = value;
            return this;
        }

        public final void setValue(Field.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        public SqlParameter build() {
            return new SqlParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SqlParameter> {
        public Builder name(String var1);

        public Builder typeHint(String var1);

        public Builder typeHint(TypeHint var1);

        public Builder value(Field var1);

        default public Builder value(Consumer<Field.Builder> value) {
            return this.value((Field)((Field.Builder)Field.builder().applyMutation(value)).build());
        }
    }
}

