/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.CustomAvailabilityZone;
import software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesRequest;
import software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesResponse;

public class DescribeCustomAvailabilityZonesIterable
implements SdkIterable<DescribeCustomAvailabilityZonesResponse> {
    private final RdsClient client;
    private final DescribeCustomAvailabilityZonesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCustomAvailabilityZonesIterable(RdsClient client, DescribeCustomAvailabilityZonesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeCustomAvailabilityZonesResponseFetcher();
    }

    public Iterator<DescribeCustomAvailabilityZonesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CustomAvailabilityZone> customAvailabilityZones() {
        Function<DescribeCustomAvailabilityZonesResponse, Iterator> getIterator = response -> {
            if (response != null && response.customAvailabilityZones() != null) {
                return response.customAvailabilityZones().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeCustomAvailabilityZonesResponseFetcher
    implements SyncPageFetcher<DescribeCustomAvailabilityZonesResponse> {
        private DescribeCustomAvailabilityZonesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCustomAvailabilityZonesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeCustomAvailabilityZonesResponse nextPage(DescribeCustomAvailabilityZonesResponse previousPage) {
            if (previousPage == null) {
                return DescribeCustomAvailabilityZonesIterable.this.client.describeCustomAvailabilityZones(DescribeCustomAvailabilityZonesIterable.this.firstRequest);
            }
            return DescribeCustomAvailabilityZonesIterable.this.client.describeCustomAvailabilityZones((DescribeCustomAvailabilityZonesRequest)((Object)DescribeCustomAvailabilityZonesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

